@extends('layouts.app')

@section('title', 'قوالب القيود المحاسبية')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">قوالب القيود المحاسبية</h3>
                    <div>
                        @can('create_journal_templates')
                        <a href="{{ route('journal-templates.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> إضافة قالب جديد
                        </a>
                        @endcan
                    </div>
                </div>
                <div class="card-body">
                    @if($templates->isEmpty())
                        <div class="alert alert-info">
                            لا توجد قوالب قيود محاسبية. يمكنك إنشاء قالب جديد بالنقر على زر "إضافة قالب جديد".
                        </div>
                    @else
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>اسم القالب</th>
                                        <th>الوصف</th>
                                        <th>عدد البنود</th>
                                        <th>تم إنشاؤه بواسطة</th>
                                        <th>تاريخ الإنشاء</th>
                                        <th>الإجراءات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($templates as $template)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $template->name }}</td>
                                        <td>{{ Str::limit($template->description, 50) }}</td>
                                        <td>{{ $template->items_count ?? $template->items->count() }}</td>
                                        <td>{{ $template->creator->name ?? 'غير معروف' }}</td>
                                        <td>{{ $template->created_at->format('Y-m-d') }}</td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="{{ route('journal-templates.show', $template->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @can('edit_journal_templates')
                                                <a href="{{ route('journal-templates.edit', $template->id) }}" class="btn btn-sm btn-primary">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                @endcan
                                                @can('delete_journal_templates')
                                                <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#deleteModal{{ $template->id }}">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                                @endcan
                                                <a href="{{ route('journal-entries.create', ['template_id' => $template->id]) }}" class="btn btn-sm btn-success">
                                                    <i class="fas fa-plus-circle"></i> إنشاء قيد
                                                </a>
                                            </div>
                                            
                                            <!-- Modal for Delete Confirmation -->
                                            <div class="modal fade" id="deleteModal{{ $template->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel{{ $template->id }}" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="deleteModalLabel{{ $template->id }}">تأكيد الحذف</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            هل أنت متأكد من رغبتك في حذف قالب "{{ $template->name }}"؟
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                            <form action="{{ route('journal-templates.destroy', $template->id) }}" method="POST" style="display: inline-block;">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit" class="btn btn-danger">حذف</button>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        
                        <div class="mt-4">
                            {{ $templates->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        // تفعيل tooltips
        $('[data-toggle="tooltip"]').tooltip();
        
        // تفعيل modals
        $('.modal').on('shown.bs.modal', function () {
            $(this).find('[autofocus]').focus();
        });
    });
</script>
@endpush