@extends('layouts.app')

@section('title', 'تعديل قالب قيد محاسبي')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تعديل قالب قيد محاسبي</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('journal-templates.update', $template->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name">اسم القالب <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name', $template->name) }}" required>
                                    @error('name')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="description">الوصف</label>
                                    <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3">{{ old('description', $template->description) }}</textarea>
                                    @error('description')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <hr>
                        <h4>بنود القالب</h4>
                        <p class="text-muted">أضف الحسابات التي ستظهر في القالب. يجب أن يكون مجموع المدين يساوي مجموع الدائن.</p>
                        
                        <div class="table-responsive">
                            <table class="table table-bordered" id="items-table">
                                <thead>
                                    <tr>
                                        <th>الحساب</th>
                                        <th>الوصف</th>
                                        <th>مدين</th>
                                        <th>دائن</th>
                                        <th>الإجراءات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($template->items as $index => $item)
                                    <tr class="item-row">
                                        <td>
                                            <select name="items[{{ $index }}][account_id]" class="form-control account-select" required>
                                                <option value="">اختر الحساب</option>
                                                @foreach($accounts as $account)
                                                    <option value="{{ $account->id }}" {{ $item->account_id == $account->id ? 'selected' : '' }}>
                                                        {{ $account->account_code }} - {{ $account->name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                            <input type="hidden" name="items[{{ $index }}][id]" value="{{ $item->id }}">
                                        </td>
                                        <td>
                                            <input type="text" name="items[{{ $index }}][description]" class="form-control" value="{{ $item->description }}">
                                        </td>
                                        <td>
                                            <input type="number" name="items[{{ $index }}][debit]" class="form-control debit-amount" step="0.01" min="0" value="{{ $item->debit }}">
                                        </td>
                                        <td>
                                            <input type="number" name="items[{{ $index }}][credit]" class="form-control credit-amount" step="0.01" min="0" value="{{ $item->credit }}">
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-danger btn-sm remove-row">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                    @endforeach
                                    
                                    @if($template->items->isEmpty())
                                    <tr class="item-row">
                                        <td>
                                            <select name="items[0][account_id]" class="form-control account-select" required>
                                                <option value="">اختر الحساب</option>
                                                @foreach($accounts as $account)
                                                    <option value="{{ $account->id }}">{{ $account->account_code }} - {{ $account->name }}</option>
                                                @endforeach
                                            </select>
                                        </td>
                                        <td>
                                            <input type="text" name="items[0][description]" class="form-control">
                                        </td>
                                        <td>
                                            <input type="number" name="items[0][debit]" class="form-control debit-amount" step="0.01" min="0" value="0">
                                        </td>
                                        <td>
                                            <input type="number" name="items[0][credit]" class="form-control credit-amount" step="0.01" min="0" value="0">
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-danger btn-sm remove-row">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                    @endif
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="2">
                                            <button type="button" class="btn btn-success" id="add-row">
                                                <i class="fas fa-plus"></i> إضافة بند
                                            </button>
                                        </td>
                                        <td>
                                            <strong>المجموع: </strong>
                                            <span id="total-debit">0.00</span>
                                        </td>
                                        <td>
                                            <strong>المجموع: </strong>
                                            <span id="total-credit">0.00</span>
                                        </td>
                                        <td></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        
                        <div class="alert alert-warning mt-3" id="balance-warning" style="display: none;">
                            <i class="fas fa-exclamation-triangle"></i>
                            مجموع المدين لا يساوي مجموع الدائن. يجب أن يكون القيد متوازناً.
                        </div>
                        
                        <div class="form-group mt-4">
                            <button type="submit" class="btn btn-primary" id="submit-btn">
                                <i class="fas fa-save"></i> حفظ التغييرات
                            </button>
                            <a href="{{ route('journal-templates.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> إلغاء
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        let rowIndex = {{ $template->items->count() > 0 ? $template->items->count() - 1 : 0 }};
        
        // إضافة صف جديد
        $('#add-row').on('click', function() {
            rowIndex++;
            const newRow = `
                <tr class="item-row">
                    <td>
                        <select name="items[${rowIndex}][account_id]" class="form-control account-select" required>
                            <option value="">اختر الحساب</option>
                            @foreach($accounts as $account)
                                <option value="{{ $account->id }}">{{ $account->account_code }} - {{ $account->name }}</option>
                            @endforeach
                        </select>
                    </td>
                    <td>
                        <input type="text" name="items[${rowIndex}][description]" class="form-control">
                    </td>
                    <td>
                        <input type="number" name="items[${rowIndex}][debit]" class="form-control debit-amount" step="0.01" min="0" value="0">
                    </td>
                    <td>
                        <input type="number" name="items[${rowIndex}][credit]" class="form-control credit-amount" step="0.01" min="0" value="0">
                    </td>
                    <td>
                        <button type="button" class="btn btn-danger btn-sm remove-row">
                            <i class="fas fa-trash"></i>
                        </button>
                    </td>
                </tr>
            `;
            $('#items-table tbody').append(newRow);
            updateTotals();
        });
        
        // حذف صف
        $(document).on('click', '.remove-row', function() {
            if ($('#items-table tbody tr').length > 1) {
                $(this).closest('tr').remove();
                updateTotals();
            } else {
                alert('يجب أن يحتوي القالب على بند واحد على الأقل');
            }
        });
        
        // تحديث المجاميع عند تغيير القيم
        $(document).on('input', '.debit-amount, .credit-amount', function() {
            updateTotals();
        });
        
        // منع إدخال مدين ودائن في نفس الصف
        $(document).on('input', '.debit-amount', function() {
            if (parseFloat($(this).val()) > 0) {
                $(this).closest('tr').find('.credit-amount').val(0);
            }
            updateTotals();
        });
        
        $(document).on('input', '.credit-amount', function() {
            if (parseFloat($(this).val()) > 0) {
                $(this).closest('tr').find('.debit-amount').val(0);
            }
            updateTotals();
        });
        
        // حساب المجاميع
        function updateTotals() {
            let totalDebit = 0;
            let totalCredit = 0;
            
            $('.debit-amount').each(function() {
                totalDebit += parseFloat($(this).val()) || 0;
            });
            
            $('.credit-amount').each(function() {
                totalCredit += parseFloat($(this).val()) || 0;
            });
            
            $('#total-debit').text(totalDebit.toFixed(2));
            $('#total-credit').text(totalCredit.toFixed(2));
            
            // التحقق من توازن القيد
            if (totalDebit !== totalCredit) {
                $('#balance-warning').show();
                $('#submit-btn').prop('disabled', true);
            } else {
                $('#balance-warning').hide();
                $('#submit-btn').prop('disabled', false);
            }
        }
        
        // التحقق من النموذج قبل الإرسال
        $('form').on('submit', function(e) {
            const totalDebit = parseFloat($('#total-debit').text());
            const totalCredit = parseFloat($('#total-credit').text());
            
            if (totalDebit !== totalCredit) {
                e.preventDefault();
                alert('يجب أن يكون مجموع المدين يساوي مجموع الدائن');
                return false;
            }
            
            if (totalDebit === 0 && totalCredit === 0) {
                e.preventDefault();
                alert('يجب إدخال قيم للمدين والدائن');
                return false;
            }
            
            return true;
        });
        
        // تهيئة المجاميع عند تحميل الصفحة
        updateTotals();
    });
</script>
@endpush