@extends('layouts.app')

@section('title', 'تفاصيل القيد المحاسبي')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تفاصيل القيد المحاسبي #{{ $entry->entry_number }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('journal-entries.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-primary">
                                    <h5 class="card-title">معلومات القيد</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">رقم القيد</th>
                                            <td>{{ $entry->entry_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>التاريخ</th>
                                            <td>{{ $entry->entry_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>المرجع</th>
                                            <td>{{ $entry->formatted_reference }}</td>
                                        </tr>
                                        <tr>
                                            <th>السنة المالية</th>
                                            <td>{{ $entry->fiscalYear->name ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الفترة المحاسبية</th>
                                            <td>{{ $entry->accountingPeriod->name ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @if($entry->is_posted)
                                                    <span class="badge badge-success">مرحل</span>
                                                @else
                                                    <span class="badge badge-warning">غير مرحل</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>تم الإنشاء بواسطة</th>
                                            <td>{{ $entry->creator->name ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الإنشاء</th>
                                            <td>{{ $entry->created_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                    </table>
                                    
                                    <div class="mt-3">
                                        @if(!$entry->is_posted)
                                            @can('edit_journal_entries')
                                            <a href="{{ route('journal-entries.edit', $entry->id) }}" class="btn btn-warning">
                                                <i class="fas fa-edit"></i> تعديل
                                            </a>
                                            @endcan
                                            
                                            @can('post_journal_entries')
                                            <form action="{{ route('journal-entries.post', $entry->id) }}" method="POST" style="display: inline;">
                                                @csrf
                                                <button type="submit" class="btn btn-success" onclick="return confirm('هل أنت متأكد من ترحيل هذا القيد؟')">
                                                    <i class="fas fa-check"></i> ترحيل القيد
                                                </button>
                                            </form>
                                            @endcan
                                            
                                            @can('delete_journal_entries')
                                            <form action="{{ route('journal-entries.destroy', $entry->id) }}" method="POST" style="display: inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger" onclick="return confirm('هل أنت متأكد من حذف هذا القيد؟')">
                                                    <i class="fas fa-trash"></i> حذف
                                                </button>
                                            </form>
                                            @endcan
                                        @else
                                            @can('unpost_journal_entries')
                                            <form action="{{ route('journal-entries.unpost', $entry->id) }}" method="POST" style="display: inline;">
                                                @csrf
                                                <button type="submit" class="btn btn-secondary" onclick="return confirm('هل أنت متأكد من إلغاء ترحيل هذا القيد؟')">
                                                    <i class="fas fa-undo"></i> إلغاء الترحيل
                                                </button>
                                            </form>
                                            @endcan
                                        @endif
                                        
                                        <a href="{{ route('journal-entries.print', $entry->id) }}" class="btn btn-info" target="_blank">
                                            <i class="fas fa-print"></i> طباعة
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-info">
                                    <h5 class="card-title">الوصف</h5>
                                </div>
                                <div class="card-body">
                                    <p>{{ $entry->description }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header bg-secondary">
                                    <h5 class="card-title">تفاصيل القيد</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>الحساب</th>
                                                    <th>البيان</th>
                                                    <th>مدين</th>
                                                    <th>دائن</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($entry->items as $detail)
                                                <tr>
                                                    <td>{{ $loop->iteration }}</td>
                                                    <td>
                                                        {{ $detail->account->name ?? 'غير محدد' }}
                                                        @if($detail->account)
                                                            <small class="text-muted d-block">({{ $detail->account->code }})</small>
                                                        @endif
                                                    </td>
                                                    <td>{{ $detail->description ?: $entry->description }}</td>
                                                    <td class="text-left">{{ $detail->debit > 0 ? number_format($detail->debit, 2) : '' }}</td>
                                                    <td class="text-left">{{ $detail->credit > 0 ? number_format($detail->credit, 2) : '' }}</td>
                                                </tr>
                                                @empty
                                                <tr>
                                                    <td colspan="5" class="text-center">لا توجد تفاصيل للقيد</td>
                                                </tr>
                                                @endforelse
                                            </tbody>
                                            <tfoot>
                                                <tr class="bg-light">
                                                    <th colspan="3" class="text-left">الإجمالي</th>
                                                    <th class="text-left">{{ number_format($entry->items->sum('debit'), 2) }}</th>
                                                    <th class="text-left">{{ number_format($entry->items->sum('credit'), 2) }}</th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection