<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>طباعة القيد المحاسبي #{{ $entry->entry_number }}</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 20px;
            direction: rtl;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
            border: 1px solid #ddd;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #333;
        }
        .company-name {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 5px;
        }
        .document-title {
            font-size: 18px;
            margin-bottom: 5px;
        }
        .info-table {
            width: 100%;
            margin-bottom: 20px;
            border-collapse: collapse;
        }
        .info-table th, .info-table td {
            padding: 8px;
            border: 1px solid #ddd;
        }
        .info-table th {
            background-color: #f5f5f5;
            width: 30%;
            text-align: right;
        }
        .details-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        .details-table th, .details-table td {
            padding: 8px;
            border: 1px solid #ddd;
            text-align: right;
        }
        .details-table th {
            background-color: #f5f5f5;
        }
        .details-table tfoot {
            font-weight: bold;
        }
        .description-box {
            padding: 10px;
            border: 1px solid #ddd;
            margin-bottom: 20px;
            background-color: #f9f9f9;
        }
        .signatures {
            display: flex;
            justify-content: space-between;
            margin-top: 50px;
        }
        .signature-box {
            width: 30%;
            text-align: center;
        }
        .signature-line {
            border-top: 1px solid #333;
            margin-top: 40px;
            padding-top: 5px;
        }
        @media print {
            body {
                padding: 0;
            }
            .container {
                border: none;
                padding: 0;
            }
            .print-button {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="company-name">{{ $company->name ?? 'شركة المصاعد' }}</div>
            <div class="document-title">قيد محاسبي رقم: {{ $entry->entry_number }}</div>
            <div>{{ $entry->entry_date->format('Y-m-d') }}</div>
        </div>
        
        <table class="info-table">
            <tr>
                <th>رقم القيد</th>
                <td>{{ $entry->entry_number }}</td>
                <th>التاريخ</th>
                <td>{{ $entry->entry_date->format('Y-m-d') }}</td>
            </tr>
            <tr>
                <th>المرجع</th>
                <td>{{ $entry->formatted_reference }}</td>
                <th>الحالة</th>
                <td>
                    @if($entry->is_posted)
                        مرحل
                    @else
                        غير مرحل
                    @endif
                </td>
            </tr>
            <tr>
                <th>السنة المالية</th>
                <td>{{ $entry->fiscalYear->name ?? 'غير محدد' }}</td>
                <th>الفترة المحاسبية</th>
                <td>{{ $entry->accountingPeriod->name ?? 'غير محدد' }}</td>
            </tr>
        </table>
        
        <div class="description-box">
            <strong>الوصف:</strong>
            <p>{{ $entry->description }}</p>
        </div>
        
        <table class="details-table">
            <thead>
                <tr>
                    <th style="width: 5%;">#</th>
                    <th style="width: 35%;">الحساب</th>
                    <th style="width: 30%;">البيان</th>
                    <th style="width: 15%;">مدين</th>
                    <th style="width: 15%;">دائن</th>
                </tr>
            </thead>
            <tbody>
                @forelse($entry->items as $detail)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>
                        {{ $detail->account->name ?? 'غير محدد' }}
                        @if($detail->account)
                            <small>({{ $detail->account->code }})</small>
                        @endif
                    </td>
                    <td>{{ $detail->description ?: $entry->description }}</td>
                    <td>{{ $detail->debit > 0 ? number_format($detail->debit, 2) : '' }}</td>
                    <td>{{ $detail->credit > 0 ? number_format($detail->credit, 2) : '' }}</td>
                </tr>
                @empty
                <tr>
                    <td colspan="5" style="text-align: center;">لا توجد تفاصيل للقيد</td>
                </tr>
                @endforelse
            </tbody>
            <tfoot>
                <tr>
                    <th colspan="3" style="text-align: left;">الإجمالي</th>
                    <th>{{ number_format($entry->items->sum('debit'), 2) }}</th>
                    <th>{{ number_format($entry->items->sum('credit'), 2) }}</th>
                </tr>
            </tfoot>
        </table>
        
        <div class="signatures">
            <div class="signature-box">
                <div class="signature-line">المعد</div>
            </div>
            <div class="signature-box">
                <div class="signature-line">المراجع</div>
            </div>
            <div class="signature-box">
                <div class="signature-line">المدير المالي</div>
            </div>
        </div>
        
        <div class="print-button" style="text-align: center; margin-top: 20px;">
            <button onclick="window.print()">طباعة</button>
            <button onclick="window.close()">إغلاق</button>
        </div>
    </div>
</body>
</html>