@extends('layouts.app')

@section('title', 'القيود المحاسبية')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">القيود المحاسبية</h3>
                    <div class="card-tools">
                        @can('create_journal_entries')
                        <a href="{{ route('journal-entries.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> إضافة قيد محاسبي جديد
                        </a>
                        @endcan
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                    
                    <!-- فلاتر البحث -->
                    <div class="mb-4">
                        <form action="{{ route('journal-entries.index') }}" method="GET" class="form-inline">
                            <div class="form-group mr-2">
                                <label for="source" class="mr-1">المصدر:</label>
                                <select name="source" id="source" class="form-control form-control-sm">
                                    <option value="">الكل</option>
                                    <option value="cash_transactions" {{ request('source') == 'cash_transactions' ? 'selected' : '' }}>معاملات الخزينة</option>
                                </select>
                            </div>
                            <div class="form-group mr-2">
                                <label for="transaction_type" class="mr-1">نوع المعاملة:</label>
                                <select name="transaction_type" id="transaction_type" class="form-control form-control-sm">
                                    <option value="">الكل</option>
                                    <option value="deposit" {{ request('transaction_type') == 'deposit' ? 'selected' : '' }}>إيداع</option>
                                    <option value="withdrawal" {{ request('transaction_type') == 'withdrawal' ? 'selected' : '' }}>سحب</option>
                                </select>
                            </div>
                            <button type="submit" class="btn btn-primary btn-sm">تصفية</button>
                            <a href="{{ route('journal-entries.index') }}" class="btn btn-secondary btn-sm ml-2">إعادة تعيين</a>
                        </form>
                    </div>
                    
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>رقم القيد</th>
                                    <th>التاريخ</th>
                                    <th>الوصف</th>
                                    <th>المرجع</th>
                                    <th>السنة المالية</th>
                                    <th>الفترة المحاسبية</th>
                                    <th>المبلغ</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($entries as $entry)
                                <tr>
                                    <td>{{ $entry->entry_number }}</td>
                                    <td>{{ $entry->entry_date->format('Y-m-d') }}</td>
                                    <td>{{ Str::limit($entry->description, 50) }}</td>
                                    <td>{{ $entry->formatted_reference }}</td>
                                    <td>{{ $entry->fiscalYear->name ?? 'غير محدد' }}</td>
                                    <td>{{ $entry->accountingPeriod->name ?? 'غير محدد' }}</td>
                                    <td>{{ number_format($entry->amount, 2) }}</td>
                                    <td>
                                        @if($entry->is_posted)
                                            <span class="badge badge-success">مرحل</span>
                                        @else
                                            <span class="badge badge-warning">غير مرحل</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('journal-entries.show', $entry->id) }}" class="btn btn-info btn-sm">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            
                                            @if(!$entry->is_posted)
                                                @can('edit_journal_entries')
                                                <a href="{{ route('journal-entries.edit', $entry->id) }}" class="btn btn-warning btn-sm">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                @endcan
                                                
                                                @can('post_journal_entries')
                                                <a href="{{ route('journal-entries.post', $entry->id) }}" 
                                                   class="btn btn-success btn-sm"
                                                   onclick="return confirm('هل أنت متأكد من ترحيل هذا القيد؟')">
                                                    <i class="fas fa-check"></i>
                                                </a>
                                                @endcan
                                                
                                                @can('delete_journal_entries')
                                                <form action="{{ route('journal-entries.destroy', $entry->id) }}" method="POST" style="display: inline;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('هل أنت متأكد من حذف هذا القيد؟')">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                                @endcan
                                            @else
                                                @can('unpost_journal_entries')
                                                <a href="{{ route('journal-entries.unpost', $entry->id) }}" 
                                                   class="btn btn-secondary btn-sm"
                                                   onclick="return confirm('هل أنت متأكد من إلغاء ترحيل هذا القيد؟')">
                                                    <i class="fas fa-undo"></i>
                                                </a>
                                                @endcan
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center">لا توجد قيود محاسبية</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-3">
                        {{ $entries->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection