@extends('layouts.app')

@section('title', 'تعديل القيد المحاسبي')

@section('styles')
<style>
    .entry-line {
        margin-bottom: 15px;
        padding: 10px;
        border: 1px solid #ddd;
        border-radius: 5px;
        background-color: #f9f9f9;
    }
    .entry-line:hover {
        background-color: #f0f0f0;
    }
    .remove-line {
        color: #dc3545;
        cursor: pointer;
    }
    .remove-line:hover {
        color: #bd2130;
    }
    .total-row {
        font-weight: bold;
        background-color: #e9ecef;
        padding: 10px;
        border-radius: 5px;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تعديل القيد المحاسبي #{{ $entry->entry_number }}</h3>
                </div>
                <div class="card-body">
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                    
                    <form action="{{ route('journal-entries.update', $entry->id) }}" method="POST" id="journalEntryForm">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="entry_date">تاريخ القيد <span class="text-danger">*</span></label>
                                    <input type="date" name="entry_date" id="entry_date" class="form-control @error('entry_date') is-invalid @enderror" value="{{ old('entry_date', $entry->entry_date->format('Y-m-d')) }}" required>
                                    @error('entry_date')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="reference">المرجع</label>
                                    <input type="text" name="reference" id="reference" class="form-control @error('reference') is-invalid @enderror" value="{{ old('reference', $entry->reference) }}">
                                    @error('reference')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="currency_id">العملة</label>
                                    <select name="currency_id" id="currency_id" class="form-control @error('currency_id') is-invalid @enderror">
                                        @foreach($currencies ?? [] as $currency)
                                            <option value="{{ $currency->id }}" {{ old('currency_id', $entry->currency_id) == $currency->id ? 'selected' : '' }}>
                                                {{ $currency->name }} ({{ $currency->code }})
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('currency_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="description">الوصف <span class="text-danger">*</span></label>
                            <textarea name="description" id="description" class="form-control @error('description') is-invalid @enderror" rows="3" required>{{ old('description', $entry->description) }}</textarea>
                            @error('description')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <hr>
                        
                        <h4>تفاصيل القيد</h4>
                        
                        <div id="entry-lines-container">
                            @foreach($entry->details as $index => $detail)
                            <div class="entry-line" id="line-{{ $index }}">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>الحساب <span class="text-danger">*</span></label>
                                            <select name="lines[{{ $index }}][account_id]" class="form-control account-select" required>
                                                <option value="">اختر الحساب</option>
                                                @foreach($accounts ?? [] as $account)
                                                    <option value="{{ $account->id }}" {{ $detail->account_id == $account->id ? 'selected' : '' }}>
                                                        {{ $account->name }} ({{ $account->code }})
                                                    </option>
                                                @endforeach
                                            </select>
                                            <input type="hidden" name="lines[{{ $index }}][id]" value="{{ $detail->id }}">
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>النوع <span class="text-danger">*</span></label>
                                            <select name="lines[{{ $index }}][type]" class="form-control entry-type" required>
                                                <option value="debit" {{ $detail->debit > 0 ? 'selected' : '' }}>مدين</option>
                                                <option value="credit" {{ $detail->credit > 0 ? 'selected' : '' }}>دائن</option>
                                            </select>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>المبلغ <span class="text-danger">*</span></label>
                                            <input type="number" name="lines[{{ $index }}][amount]" class="form-control amount-input" step="0.01" min="0.01" value="{{ $detail->debit > 0 ? $detail->debit : $detail->credit }}" required>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <div class="d-flex">
                                                <button type="button" class="btn btn-danger remove-line-btn" data-line="{{ $index }}">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>البيان</label>
                                            <input type="text" name="lines[{{ $index }}][description]" class="form-control" value="{{ $detail->description }}">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                        
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <button type="button" class="btn btn-info" id="add-line-btn">
                                    <i class="fas fa-plus"></i> إضافة سطر جديد
                                </button>
                            </div>
                        </div>
                        
                        <div class="row mt-3">
                            <div class="col-md-6">
                                <div class="total-row">
                                    <span>إجمالي المدين: </span>
                                    <span id="total-debit">0.00</span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="total-row">
                                    <span>إجمالي الدائن: </span>
                                    <span id="total-credit">0.00</span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div id="balance-warning" class="alert alert-warning d-none">
                                    القيد غير متوازن. يجب أن يتساوى إجمالي المدين مع إجمالي الدائن.
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group mt-4">
                            <button type="submit" class="btn btn-primary" id="submit-btn">حفظ التغييرات</button>
                            <a href="{{ route('journal-entries.index') }}" class="btn btn-secondary">إلغاء</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(function() {
        // تحديث الإجماليات عند تحميل الصفحة
        updateTotals();
        
        // زر إضافة سطر جديد
        $('#add-line-btn').on('click', function() {
            addEntryLine();
        });
        
        // التحقق من توازن القيد قبل الإرسال
        $('#journalEntryForm').on('submit', function(e) {
            updateTotals();
            
            var totalDebit = parseFloat($('#total-debit').text());
            var totalCredit = parseFloat($('#total-credit').text());
            
            if (totalDebit !== totalCredit) {
                e.preventDefault();
                $('#balance-warning').removeClass('d-none');
                $('html, body').animate({
                    scrollTop: $('#balance-warning').offset().top - 100
                }, 500);
            }
        });
        
        // حذف سطر
        $('.remove-line-btn').on('click', function() {
            var lineId = $(this).data('line');
            $('#line-' + lineId).remove();
            updateTotals();
        });
        
        // تحديث الإجماليات عند تغيير المبلغ أو النوع
        $('.amount-input, .entry-type').on('change keyup', function() {
            updateTotals();
        });
    });
    
    // دالة إضافة سطر جديد
    function addEntryLine() {
        var lineCount = $('.entry-line').length;
        var lineHtml = `
            <div class="entry-line" id="line-${lineCount}">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>الحساب <span class="text-danger">*</span></label>
                            <select name="lines[${lineCount}][account_id]" class="form-control account-select" required>
                                <option value="">اختر الحساب</option>
                                @foreach($accounts ?? [] as $account)
                                    <option value="{{ $account->id }}">{{ $account->name }} ({{ $account->code }})</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>النوع <span class="text-danger">*</span></label>
                            <select name="lines[${lineCount}][type]" class="form-control entry-type" required>
                                <option value="debit">مدين</option>
                                <option value="credit">دائن</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>المبلغ <span class="text-danger">*</span></label>
                            <input type="number" name="lines[${lineCount}][amount]" class="form-control amount-input" step="0.01" min="0.01" required>
                        </div>
                    </div>
                    
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <div class="d-flex">
                                <button type="button" class="btn btn-danger remove-line-btn" data-line="${lineCount}">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label>البيان</label>
                            <input type="text" name="lines[${lineCount}][description]" class="form-control">
                        </div>
                    </div>
                </div>
            </div>
        `;
        
        $('#entry-lines-container').append(lineHtml);
        
        // حذف سطر
        $('.remove-line-btn').off('click').on('click', function() {
            var lineId = $(this).data('line');
            $('#line-' + lineId).remove();
            updateTotals();
        });
        
        // تحديث الإجماليات عند تغيير المبلغ أو النوع
        $('.amount-input, .entry-type').off('change keyup').on('change keyup', function() {
            updateTotals();
        });
        
        // تحديث الإجماليات بعد إضافة السطر
        updateTotals();
    }
    
    // دالة تحديث الإجماليات
    function updateTotals() {
        var totalDebit = 0;
        var totalCredit = 0;
        
        $('.entry-line').each(function() {
            var amount = parseFloat($(this).find('.amount-input').val()) || 0;
            var type = $(this).find('.entry-type').val();
            
            if (type === 'debit') {
                totalDebit += amount;
            } else if (type === 'credit') {
                totalCredit += amount;
            }
        });
        
        $('#total-debit').text(totalDebit.toFixed(2));
        $('#total-credit').text(totalCredit.toFixed(2));
        
        // التحقق من توازن القيد
        if (totalDebit === totalCredit && totalDebit > 0) {
            $('#balance-warning').addClass('d-none');
        } else {
            $('#balance-warning').removeClass('d-none');
        }
    }
</script>
@endsection