@extends('layouts.app')

@section('title', 'إضافة قيد محاسبي جديد')

@push('styles')
<style>
    .entry-line {
        margin-bottom: 15px;
        padding: 10px;
        border: 1px solid #ddd;
        border-radius: 5px;
        background-color: #f9f9f9;
    }
    .entry-line:hover {
        background-color: #f0f0f0;
    }
    .remove-line {
        color: #dc3545;
        cursor: pointer;
    }
    .remove-line:hover {
        color: #bd2130;
    }
    .total-row {
        font-weight: bold;
        background-color: #e9ecef;
        padding: 10px;
        border-radius: 5px;
    }
</style>
@endpush

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إضافة قيد محاسبي جديد</h3>
                </div>
                <div class="card-body">
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                    
                    <form action="{{ route('journal-entries.store') }}" method="POST" id="journalEntryForm">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="entry_date">تاريخ القيد <span class="text-danger">*</span></label>
                                    <input type="date" name="entry_date" id="entry_date" class="form-control @error('entry_date') is-invalid @enderror" value="{{ old('entry_date', date('Y-m-d')) }}" required>
                                    @error('entry_date')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="reference">المرجع</label>
                                    <input type="text" name="reference" id="reference" class="form-control @error('reference') is-invalid @enderror" value="{{ old('reference') }}">
                                    @error('reference')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="currency_id">العملة</label>
                                    <select name="currency_id" id="currency_id" class="form-control @error('currency_id') is-invalid @enderror">
                                        @foreach($currencies ?? [] as $currency)
                                            <option value="{{ $currency->id }}" {{ old('currency_id') == $currency->id ? 'selected' : '' }}>
                                                {{ $currency->name }} ({{ $currency->code }})
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('currency_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="description">الوصف <span class="text-danger">*</span></label>
                            <textarea name="description" id="description" class="form-control @error('description') is-invalid @enderror" rows="3" required>{{ old('description') }}</textarea>
                            @error('description')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <hr>
                        
                        <h4>تفاصيل القيد</h4>
                        
                        <!-- سطر مدين افتراضي -->
                        <div class="entry-line" id="line-0">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>الحساب <span class="text-danger">*</span></label>
                                        <select name="lines[0][account_id]" class="form-control account-select" required>
                                            <option value="">اختر الحساب</option>
                                            @foreach($accounts ?? [] as $account)
                                                <option value="{{ $account->id }}">{{ $account->name }} ({{ $account->code }})</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>النوع <span class="text-danger">*</span></label>
                                        <select name="lines[0][type]" class="form-control entry-type" required>
                                            <option value="debit" selected>مدين</option>
                                            <option value="credit">دائن</option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>المبلغ <span class="text-danger">*</span></label>
                                        <input type="number" name="lines[0][amount]" class="form-control amount-input" step="0.01" min="0.01" required>
                                    </div>
                                </div>
                                
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>&nbsp;</label>
                                        <div class="d-flex">
                                            <button type="button" class="btn btn-danger remove-line-btn">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>البيان</label>
                                        <input type="text" name="lines[0][description]" class="form-control">
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- سطر دائن افتراضي -->
                        <div class="entry-line" id="line-1">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>الحساب <span class="text-danger">*</span></label>
                                        <select name="lines[1][account_id]" class="form-control account-select" required>
                                            <option value="">اختر الحساب</option>
                                            @foreach($accounts ?? [] as $account)
                                                <option value="{{ $account->id }}">{{ $account->name }} ({{ $account->code }})</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>النوع <span class="text-danger">*</span></label>
                                        <select name="lines[1][type]" class="form-control entry-type" required>
                                            <option value="debit">مدين</option>
                                            <option value="credit" selected>دائن</option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>المبلغ <span class="text-danger">*</span></label>
                                        <input type="number" name="lines[1][amount]" class="form-control amount-input" step="0.01" min="0.01" required>
                                    </div>
                                </div>
                                
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>&nbsp;</label>
                                        <div class="d-flex">
                                            <button type="button" class="btn btn-danger remove-line-btn">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>البيان</label>
                                        <input type="text" name="lines[1][description]" class="form-control">
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div id="entry-lines-container">
                            <!-- سيتم إضافة سطور إضافية هنا -->
                        </div>
                        
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <button type="button" class="btn btn-info" id="add-line-btn" onclick="addEntryLine()">
                                    <i class="fas fa-plus"></i> إضافة سطر جديد
                                </button>
                            </div>
                        </div>
                        
                        <div class="row mt-3">
                            <div class="col-md-6">
                                <div class="total-row">
                                    <span>إجمالي المدين: </span>
                                    <span id="total-debit">0.00</span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="total-row">
                                    <span>إجمالي الدائن: </span>
                                    <span id="total-credit">0.00</span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div id="balance-warning" class="alert alert-warning d-none">
                                    القيد غير متوازن. يجب أن يتساوى إجمالي المدين مع إجمالي الدائن.
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group mt-4">
                            <button type="submit" class="btn btn-primary" id="submit-btn">حفظ</button>
                            <a href="{{ route('journal-entries.index') }}" class="btn btn-secondary">إلغاء</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection



@push('scripts')
<script>
    // تعريف الدوال مباشرة في الصفحة
    function addEntryLine() {
        console.log('addEntryLine function called');
        
        // حساب عدد السطور الحالية
        var lineCount = document.querySelectorAll('.entry-line').length;
        
        // إنشاء عنصر div جديد
        var newLine = document.createElement('div');
        newLine.className = 'entry-line';
        newLine.id = 'line-' + lineCount;
        
        // إضافة محتوى السطر
        newLine.innerHTML = `
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>الحساب <span class="text-danger">*</span></label>
                        <select name="lines[${lineCount}][account_id]" class="form-control account-select" required>
                            <option value="">اختر الحساب</option>
                            @foreach($accounts ?? [] as $account)
                                <option value="{{ $account->id }}">{{ $account->name }} ({{ $account->code }})</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                
                <div class="col-md-3">
                    <div class="form-group">
                        <label>النوع <span class="text-danger">*</span></label>
                        <select name="lines[${lineCount}][type]" class="form-control entry-type" required>
                            <option value="debit">مدين</option>
                            <option value="credit">دائن</option>
                        </select>
                    </div>
                </div>
                
                <div class="col-md-3">
                    <div class="form-group">
                        <label>المبلغ <span class="text-danger">*</span></label>
                        <input type="number" name="lines[${lineCount}][amount]" class="form-control amount-input" step="0.01" min="0.01" required>
                    </div>
                </div>
                
                <div class="col-md-2">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div class="d-flex">
                            <button type="button" class="btn btn-danger remove-line-btn" onclick="removeLine(this)">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <label>البيان</label>
                        <input type="text" name="lines[${lineCount}][description]" class="form-control">
                    </div>
                </div>
            </div>
        `;
        
        // إضافة السطر إلى الحاوية
        document.getElementById('entry-lines-container').appendChild(newLine);
        
        // تحديث الإجماليات
        updateTotals();
    }
    
    function removeLine(button) {
        console.log('removeLine function called');
        
        // الحصول على السطر الذي يحتوي على الزر
        var line = button.closest('.entry-line');
        
        // حذف السطر
        if (line) {
            line.remove();
            
            // تحديث الإجماليات
            updateTotals();
        }
    }
    
    function updateTotals() {
        console.log('updateTotals function called');
        
        var totalDebit = 0;
        var totalCredit = 0;
        
        // الحصول على جميع سطور القيد
        var lines = document.querySelectorAll('.entry-line');
        
        // حساب الإجماليات
        lines.forEach(function(line) {
            var amountInput = line.querySelector('.amount-input');
            var typeSelect = line.querySelector('.entry-type');
            
            if (amountInput && typeSelect) {
                var amount = parseFloat(amountInput.value) || 0;
                var type = typeSelect.value;
                
                if (type === 'debit') {
                    totalDebit += amount;
                } else if (type === 'credit') {
                    totalCredit += amount;
                }
            }
        });
        
        // تحديث عناصر الإجماليات
        var totalDebitElement = document.getElementById('total-debit');
        var totalCreditElement = document.getElementById('total-credit');
        var balanceWarning = document.getElementById('balance-warning');
        
        if (totalDebitElement) totalDebitElement.textContent = totalDebit.toFixed(2);
        if (totalCreditElement) totalCreditElement.textContent = totalCredit.toFixed(2);
        
        // التحقق من توازن القيد
        if (balanceWarning) {
            if (totalDebit === totalCredit && totalDebit > 0) {
                balanceWarning.classList.add('d-none');
            } else {
                balanceWarning.classList.remove('d-none');
            }
        }
    }
    
    // عند تحميل المستند
    document.addEventListener('DOMContentLoaded', function() {
        console.log('DOM fully loaded');
        
        // إضافة معالجات الأحداث للحقول الموجودة
        var amountInputs = document.querySelectorAll('.amount-input');
        var typeSelects = document.querySelectorAll('.entry-type');
        
        amountInputs.forEach(function(input) {
            input.addEventListener('change', updateTotals);
            input.addEventListener('keyup', updateTotals);
        });
        
        typeSelects.forEach(function(select) {
            select.addEventListener('change', updateTotals);
        });
        
        // التحقق من توازن القيد قبل الإرسال
        var journalEntryForm = document.getElementById('journalEntryForm');
        if (journalEntryForm) {
            journalEntryForm.addEventListener('submit', function(e) {
                updateTotals();
                
                var totalDebit = parseFloat(document.getElementById('total-debit').textContent);
                var totalCredit = parseFloat(document.getElementById('total-credit').textContent);
                
                if (totalDebit !== totalCredit) {
                    e.preventDefault();
                    document.getElementById('balance-warning').classList.remove('d-none');
                    window.scrollTo({
                        top: document.getElementById('balance-warning').offsetTop - 100,
                        behavior: 'smooth'
                    });
                }
            });
        }
        
        // تحديث الإجماليات عند تحميل الصفحة
        updateTotals();
    });
</script>
@endpush