@extends('layouts.app')

@section('title', 'تفاصيل السنة المالية')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تفاصيل السنة المالية: {{ $fiscalYear->name }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('fiscal-years.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-primary">
                                    <h5 class="card-title">معلومات السنة المالية</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">الاسم</th>
                                            <td>{{ $fiscalYear->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ البداية</th>
                                            <td>{{ $fiscalYear->start_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ النهاية</th>
                                            <td>{{ $fiscalYear->end_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @if($fiscalYear->is_closed)
                                                    <span class="badge badge-danger">مغلقة</span>
                                                @elseif($fiscalYear->is_active)
                                                    <span class="badge badge-success">نشطة</span>
                                                @else
                                                    <span class="badge badge-warning">غير نشطة</span>
                                                @endif
                                            </td>
                                        </tr>
                                    </table>
                                    
                                    <div class="mt-3">
                                        @if(!$fiscalYear->is_closed)
                                            @can('edit_fiscal_years')
                                            <a href="{{ route('fiscal-years.edit', $fiscalYear->id) }}" class="btn btn-warning">
                                                <i class="fas fa-edit"></i> تعديل
                                            </a>
                                            @endcan
                                            
                                            @can('close_fiscal_years')
                                            <a href="{{ route('fiscal-years.close', $fiscalYear->id) }}" 
                                               class="btn btn-danger"
                                               onclick="return confirm('هل أنت متأكد من إغلاق هذه السنة المالية؟')">
                                                <i class="fas fa-lock"></i> إغلاق السنة المالية
                                            </a>
                                            @endcan
                                        @else
                                            @can('reopen_fiscal_years')
                                            <a href="{{ route('fiscal-years.reopen', $fiscalYear->id) }}" 
                                               class="btn btn-success"
                                               onclick="return confirm('هل أنت متأكد من إعادة فتح هذه السنة المالية؟')">
                                                <i class="fas fa-lock-open"></i> إعادة فتح السنة المالية
                                            </a>
                                            @endcan
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-info">
                                    <h5 class="card-title">إحصائيات</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="info-box">
                                                <span class="info-box-icon bg-info"><i class="far fa-calendar-alt"></i></span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">الفترات المحاسبية</span>
                                                    <span class="info-box-number">{{ $fiscalYear->accountingPeriods->count() }}</span>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="info-box">
                                                <span class="info-box-icon bg-success"><i class="fas fa-check-circle"></i></span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">الفترات المغلقة</span>
                                                    <span class="info-box-number">{{ $fiscalYear->accountingPeriods->where('is_closed', true)->count() }}</span>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="info-box">
                                                <span class="info-box-icon bg-warning"><i class="fas fa-book"></i></span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">القيود المحاسبية</span>
                                                    <span class="info-box-number">{{ $fiscalYear->journalEntries->count() }}</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header bg-secondary">
                                    <h5 class="card-title">الفترات المحاسبية</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>الاسم</th>
                                                    <th>تاريخ البداية</th>
                                                    <th>تاريخ النهاية</th>
                                                    <th>الحالة</th>
                                                    <th>الإجراءات</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($fiscalYear->accountingPeriods as $period)
                                                <tr>
                                                    <td>{{ $loop->iteration }}</td>
                                                    <td>{{ $period->name }}</td>
                                                    <td>{{ $period->start_date->format('Y-m-d') }}</td>
                                                    <td>{{ $period->end_date->format('Y-m-d') }}</td>
                                                    <td>
                                                        @if($period->is_closed)
                                                            <span class="badge badge-danger">مغلقة</span>
                                                        @else
                                                            <span class="badge badge-success">مفتوحة</span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        <div class="btn-group">
                                                            <a href="{{ route('accounting-periods.show', $period->id) }}" class="btn btn-info btn-sm">
                                                                <i class="fas fa-eye"></i>
                                                            </a>
                                                            
                                                            @if(!$period->is_closed && !$fiscalYear->is_closed)
                                                                @can('close_accounting_periods')
                                                                <a href="{{ route('accounting-periods.close', $period->id) }}" 
                                                                   class="btn btn-danger btn-sm"
                                                                   onclick="return confirm('هل أنت متأكد من إغلاق هذه الفترة المحاسبية؟')">
                                                                    <i class="fas fa-lock"></i>
                                                                </a>
                                                                @endcan
                                                            @elseif(!$fiscalYear->is_closed)
                                                                @can('reopen_accounting_periods')
                                                                <a href="{{ route('accounting-periods.reopen', $period->id) }}" 
                                                                   class="btn btn-success btn-sm"
                                                                   onclick="return confirm('هل أنت متأكد من إعادة فتح هذه الفترة المحاسبية؟')">
                                                                    <i class="fas fa-lock-open"></i>
                                                                </a>
                                                                @endcan
                                                            @endif
                                                        </div>
                                                    </td>
                                                </tr>
                                                @empty
                                                <tr>
                                                    <td colspan="6" class="text-center">لا توجد فترات محاسبية</td>
                                                </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection