@extends('layouts.app')

@section('title', 'السنوات المالية')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">السنوات المالية</h3>
                    <div class="card-tools">
                        @can('create_fiscal_years')
                        <a href="{{ route('fiscal-years.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> إضافة سنة مالية جديدة
                        </a>
                        @endcan
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                    
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>الاسم</th>
                                    <th>تاريخ البداية</th>
                                    <th>تاريخ النهاية</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($fiscalYears as $fiscalYear)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $fiscalYear->name }}</td>
                                    <td>{{ $fiscalYear->start_date->format('Y-m-d') }}</td>
                                    <td>{{ $fiscalYear->end_date->format('Y-m-d') }}</td>
                                    <td>
                                        @if($fiscalYear->is_closed)
                                            <span class="badge badge-danger">مغلقة</span>
                                        @elseif($fiscalYear->is_active)
                                            <span class="badge badge-success">نشطة</span>
                                        @else
                                            <span class="badge badge-warning">غير نشطة</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('fiscal-years.show', $fiscalYear->id) }}" class="btn btn-info btn-sm">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            
                                            @if(!$fiscalYear->is_closed)
                                                @can('edit_fiscal_years')
                                                <a href="{{ route('fiscal-years.edit', $fiscalYear->id) }}" class="btn btn-warning btn-sm">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                @endcan
                                                
                                                @can('close_fiscal_years')
                                                <a href="{{ route('fiscal-years.close', $fiscalYear->id) }}" 
                                                   class="btn btn-danger btn-sm"
                                                   onclick="return confirm('هل أنت متأكد من إغلاق هذه السنة المالية؟')">
                                                    <i class="fas fa-lock"></i>
                                                </a>
                                                @endcan
                                            @else
                                                @can('reopen_fiscal_years')
                                                <a href="{{ route('fiscal-years.reopen', $fiscalYear->id) }}" 
                                                   class="btn btn-success btn-sm"
                                                   onclick="return confirm('هل أنت متأكد من إعادة فتح هذه السنة المالية؟')">
                                                    <i class="fas fa-lock-open"></i>
                                                </a>
                                                @endcan
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="6" class="text-center">لا توجد سنوات مالية</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-3">
                        {{ $fiscalYears->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection