@extends('layouts.app')

@section('title', 'تعديل السنة المالية')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تعديل السنة المالية: {{ $fiscalYear->name }}</h3>
                </div>
                <div class="card-body">
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                    
                    <form action="{{ route('fiscal-years.update', $fiscalYear->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="form-group">
                            <label for="name">اسم السنة المالية <span class="text-danger">*</span></label>
                            <input type="text" name="name" id="name" class="form-control @error('name') is-invalid @enderror" value="{{ old('name', $fiscalYear->name) }}" required>
                            @error('name')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="start_date">تاريخ البداية</label>
                            <input type="date" class="form-control" value="{{ $fiscalYear->start_date->format('Y-m-d') }}" disabled>
                            <small class="form-text text-muted">لا يمكن تعديل تاريخ البداية بعد إنشاء السنة المالية.</small>
                        </div>
                        
                        <div class="form-group">
                            <label for="end_date">تاريخ النهاية</label>
                            <input type="date" class="form-control" value="{{ $fiscalYear->end_date->format('Y-m-d') }}" disabled>
                            <small class="form-text text-muted">لا يمكن تعديل تاريخ النهاية بعد إنشاء السنة المالية.</small>
                        </div>
                        
                        <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="is_active" name="is_active" value="1" {{ old('is_active', $fiscalYear->is_active) ? 'checked' : '' }}>
                                <label class="custom-control-label" for="is_active">سنة مالية نشطة</label>
                            </div>
                            <small class="form-text text-muted">إذا تم تحديد هذا الخيار، سيتم إلغاء تنشيط السنوات المالية الأخرى.</small>
                        </div>
                        
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                            <a href="{{ route('fiscal-years.index') }}" class="btn btn-secondary">إلغاء</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection