@extends('layouts.app')

@section('title', 'إضافة سنة مالية جديدة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إضافة سنة مالية جديدة</h3>
                </div>
                <div class="card-body">
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                    
                    <form action="{{ route('fiscal-years.store') }}" method="POST">
                        @csrf
                        
                        <div class="form-group">
                            <label for="name">اسم السنة المالية <span class="text-danger">*</span></label>
                            <input type="text" name="name" id="name" class="form-control @error('name') is-invalid @enderror" value="{{ old('name') }}" required>
                            @error('name')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="start_date">تاريخ البداية <span class="text-danger">*</span></label>
                            <input type="date" name="start_date" id="start_date" class="form-control @error('start_date') is-invalid @enderror" value="{{ old('start_date') }}" required>
                            @error('start_date')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="end_date">تاريخ النهاية <span class="text-danger">*</span></label>
                            <input type="date" name="end_date" id="end_date" class="form-control @error('end_date') is-invalid @enderror" value="{{ old('end_date') }}" required>
                            @error('end_date')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="period_type">نوع الفترات المحاسبية</label>
                            <select name="period_type" id="period_type" class="form-control @error('period_type') is-invalid @enderror">
                                <option value="monthly" {{ old('period_type') == 'monthly' ? 'selected' : '' }}>شهرية</option>
                                <option value="quarterly" {{ old('period_type') == 'quarterly' ? 'selected' : '' }}>ربع سنوية</option>
                                <option value="semi_annual" {{ old('period_type') == 'semi_annual' ? 'selected' : '' }}>نصف سنوية</option>
                            </select>
                            @error('period_type')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="is_active" name="is_active" value="1" {{ old('is_active') ? 'checked' : '' }}>
                                <label class="custom-control-label" for="is_active">سنة مالية نشطة</label>
                            </div>
                            <small class="form-text text-muted">إذا تم تحديد هذا الخيار، سيتم إلغاء تنشيط السنوات المالية الأخرى.</small>
                        </div>
                        
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">حفظ</button>
                            <a href="{{ route('fiscal-years.index') }}" class="btn btn-secondary">إلغاء</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // التحقق من تاريخ النهاية بعد تاريخ البداية
        $('#end_date').change(function() {
            var startDate = new Date($('#start_date').val());
            var endDate = new Date($(this).val());
            
            if (endDate <= startDate) {
                alert('يجب أن يكون تاريخ النهاية بعد تاريخ البداية');
                $(this).val('');
            }
        });
    });
</script>
@endsection