@extends('layouts.app')

@section('title', 'قائمة الدخل')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">قائمة الدخل
                        @if($startDate && $endDate)
                            للفترة من {{ is_string($startDate) ? $startDate : $startDate->format('Y-m-d') }} إلى {{ is_string($endDate) ? $endDate : $endDate->format('Y-m-d') }}
                        @endif
                    </h3>
                    <div>
                        <button onclick="window.print()" class="btn btn-info">
                            <i class="fas fa-print"></i> طباعة
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('financial-statements.income-statement') }}" method="GET" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="fiscal_year_id">السنة المالية</label>
                                    <select class="form-control" id="fiscal_year_id" name="fiscal_year_id">
                                        <option value="">-- اختر السنة المالية --</option>
                                        @foreach($fiscalYears as $year)
                                            <option value="{{ $year->id }}" {{ $fiscalYearId == $year->id ? 'selected' : '' }}>
                                                {{ $year->name }} ({{ $year->start_date->format('Y-m-d') }} - {{ $year->end_date->format('Y-m-d') }})
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="start_date">تاريخ البداية</label>
                                    <input type="date" class="form-control" id="start_date" name="start_date" value="{{ $startDate ? (is_string($startDate) ? $startDate : $startDate->format('Y-m-d')) : '' }}">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="end_date">تاريخ النهاية</label>
                                    <input type="date" class="form-control" id="end_date" name="end_date" value="{{ $endDate ? (is_string($endDate) ? $endDate : $endDate->format('Y-m-d')) : '' }}">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>&nbsp;</label>
                                    <button type="submit" class="btn btn-primary btn-block">عرض</button>
                                </div>
                            </div>
                        </div>
                    </form>

                    @if($startDate && $endDate)
                        <div class="row">
                            <div class="col-md-12">
                                <!-- قسم الإيرادات -->
                                <div class="card mb-4">
                                    <div class="card-header bg-success text-white">
                                        <h5 class="mb-0">الإيرادات</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>رمز الحساب</th>
                                                        <th>اسم الحساب</th>
                                                        <th>المبلغ</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @if(count($revenues) > 0)
                                                        @foreach($revenues as $revenue)
                                                            <tr>
                                                                <td>{{ $revenue['code'] }}</td>
                                                                <td>{{ $revenue['name'] }}</td>
                                                                <td class="text-left">{{ $revenue['formatted_balance'] }}</td>
                                                            </tr>
                                                        @endforeach
                                                    @else
                                                        <tr>
                                                            <td colspan="3" class="text-center">لا توجد إيرادات للفترة المحددة</td>
                                                        </tr>
                                                    @endif
                                                </tbody>
                                                <tfoot>
                                                    <tr class="bg-light font-weight-bold">
                                                        <td colspan="2" class="text-right">إجمالي الإيرادات</td>
                                                        <td class="text-left">{{ number_format($totalRevenue, 2) }}</td>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <!-- قسم المصروفات -->
                                <div class="card mb-4">
                                    <div class="card-header bg-danger text-white">
                                        <h5 class="mb-0">المصروفات</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>رمز الحساب</th>
                                                        <th>اسم الحساب</th>
                                                        <th>المبلغ</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @if(count($expenses) > 0)
                                                        @foreach($expenses as $expense)
                                                            <tr>
                                                                <td>{{ $expense['code'] }}</td>
                                                                <td>{{ $expense['name'] }}</td>
                                                                <td class="text-left">{{ $expense['formatted_balance'] }}</td>
                                                            </tr>
                                                        @endforeach
                                                    @else
                                                        <tr>
                                                            <td colspan="3" class="text-center">لا توجد مصروفات للفترة المحددة</td>
                                                        </tr>
                                                    @endif
                                                </tbody>
                                                <tfoot>
                                                    <tr class="bg-light font-weight-bold">
                                                        <td colspan="2" class="text-right">إجمالي المصروفات</td>
                                                        <td class="text-left">{{ number_format($totalExpense, 2) }}</td>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <!-- ملخص النتائج -->
                                <div class="card">
                                    <div class="card-header bg-primary text-white">
                                        <h5 class="mb-0">ملخص النتائج</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-bordered">
                                                <tbody>
                                                    <tr class="bg-success text-white">
                                                        <td>إجمالي الإيرادات</td>
                                                        <td class="text-left">{{ number_format($totalRevenue, 2) }}</td>
                                                    </tr>
                                                    <tr class="bg-danger text-white">
                                                        <td>إجمالي المصروفات</td>
                                                        <td class="text-left">{{ number_format($totalExpense, 2) }}</td>
                                                    </tr>
                                                    <tr class="bg-primary text-white font-weight-bold">
                                                        <td>صافي الدخل</td>
                                                        <td class="text-left">
                                                            {{ number_format($netIncome, 2) }}
                                                            @if($netIncome > 0)
                                                                <span class="badge badge-success">ربح</span>
                                                            @elseif($netIncome < 0)
                                                                <span class="badge badge-danger">خسارة</span>
                                                            @else
                                                                <span class="badge badge-warning">متعادل</span>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i> يرجى تحديد الفترة الزمنية لعرض قائمة الدخل
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('styles')
<style>
    @media print {
        .btn, form, .card-header, .main-header, .main-sidebar, .main-footer {
            display: none !important;
        }
        .card {
            border: none !important;
            box-shadow: none !important;
        }
        .card-body {
            padding: 0 !important;
        }
        body {
            margin: 0;
            padding: 0;
            background: #fff;
        }
        .content-wrapper {
            background: #fff;
            margin: 0 !important;
            padding: 0 !important;
        }
    }
</style>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // Cuando cambia la selección de año fiscal, actualizar las fechas
        $('#fiscal_year_id').change(function() {
            var selectedOption = $(this).find('option:selected');
            if (selectedOption.val()) {
                var dates = selectedOption.text().match(/\(([^)]+)\)/)[1].split(' - ');
                $('#start_date').val(dates[0]);
                $('#end_date').val(dates[1]);
            } else {
                $('#start_date').val('');
                $('#end_date').val('');
            }
        });
    });
</script>
@endsection