@extends('layouts.app')

@section('title', 'قائمة التدفقات النقدية')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">قائمة التدفقات النقدية
                        @if($startDate && $endDate)
                            للفترة من {{ is_string($startDate) ? $startDate : $startDate->format('Y-m-d') }} إلى {{ is_string($endDate) ? $endDate : $endDate->format('Y-m-d') }}
                        @endif
                    </h3>
                    <div>
                        <button onclick="window.print()" class="btn btn-info">
                            <i class="fas fa-print"></i> طباعة
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('financial-statements.cash-flow') }}" method="GET" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="fiscal_year_id">السنة المالية</label>
                                    <select class="form-control" id="fiscal_year_id" name="fiscal_year_id">
                                        <option value="">-- اختر السنة المالية --</option>
                                        @foreach($fiscalYears as $year)
                                            <option value="{{ $year->id }}" {{ $fiscalYearId == $year->id ? 'selected' : '' }}>
                                                {{ $year->name }} ({{ $year->start_date->format('Y-m-d') }} - {{ $year->end_date->format('Y-m-d') }})
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="start_date">تاريخ البداية</label>
                                    <input type="date" class="form-control" id="start_date" name="start_date" value="{{ $startDate ? (is_string($startDate) ? $startDate : $startDate->format('Y-m-d')) : '' }}">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="end_date">تاريخ النهاية</label>
                                    <input type="date" class="form-control" id="end_date" name="end_date" value="{{ $endDate ? (is_string($endDate) ? $endDate : $endDate->format('Y-m-d')) : '' }}">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>&nbsp;</label>
                                    <button type="submit" class="btn btn-primary btn-block">عرض</button>
                                </div>
                            </div>
                        </div>
                    </form>

                    @if($startDate && $endDate)
                        <div class="row">
                            <div class="col-md-12">
                                <!-- معلومات الرصيد النقدي -->
                                <div class="card mb-4">
                                    <div class="card-header bg-info text-white">
                                        <h5 class="mb-0">ملخص الأرصدة النقدية</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-bordered">
                                                <tbody>
                                                    <tr>
                                                        <td class="font-weight-bold">الرصيد النقدي الافتتاحي</td>
                                                        <td class="text-left">{{ number_format($openingCashBalance, 2) }}</td>
                                                    </tr>
                                                    <tr>
                                                        <td class="font-weight-bold">الرصيد النقدي الختامي</td>
                                                        <td class="text-left">{{ number_format($closingCashBalance, 2) }}</td>
                                                    </tr>
                                                    <tr class="bg-primary text-white">
                                                        <td class="font-weight-bold">صافي التغير في النقدية</td>
                                                        <td class="text-left">{{ number_format($totalCashFlow, 2) }}</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <!-- الأنشطة التشغيلية -->
                                <div class="card mb-4">
                                    <div class="card-header bg-success text-white">
                                        <h5 class="mb-0">الأنشطة التشغيلية</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>رمز الحساب</th>
                                                        <th>اسم الحساب</th>
                                                        <th>المبلغ</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @if(count($operatingActivities) > 0)
                                                        @foreach($operatingActivities as $activity)
                                                            <tr>
                                                                <td>{{ $activity['code'] }}</td>
                                                                <td>{{ $activity['name'] }}</td>
                                                                <td class="text-left">{{ $activity['formatted_balance'] }}</td>
                                                            </tr>
                                                        @endforeach
                                                    @else
                                                        <tr>
                                                            <td colspan="3" class="text-center">لا توجد أنشطة تشغيلية للفترة المحددة</td>
                                                        </tr>
                                                    @endif
                                                </tbody>
                                                <tfoot>
                                                    <tr class="bg-light font-weight-bold">
                                                        <td colspan="2" class="text-right">صافي التدفقات النقدية من الأنشطة التشغيلية</td>
                                                        <td class="text-left">{{ number_format($totalOperating, 2) }}</td>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <!-- الأنشطة الاستثمارية -->
                                <div class="card mb-4">
                                    <div class="card-header bg-warning text-white">
                                        <h5 class="mb-0">الأنشطة الاستثمارية</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>رمز الحساب</th>
                                                        <th>اسم الحساب</th>
                                                        <th>المبلغ</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @if(count($investingActivities) > 0)
                                                        @foreach($investingActivities as $activity)
                                                            <tr>
                                                                <td>{{ $activity['code'] }}</td>
                                                                <td>{{ $activity['name'] }}</td>
                                                                <td class="text-left">{{ $activity['formatted_balance'] }}</td>
                                                            </tr>
                                                        @endforeach
                                                    @else
                                                        <tr>
                                                            <td colspan="3" class="text-center">لا توجد أنشطة استثمارية للفترة المحددة</td>
                                                        </tr>
                                                    @endif
                                                </tbody>
                                                <tfoot>
                                                    <tr class="bg-light font-weight-bold">
                                                        <td colspan="2" class="text-right">صافي التدفقات النقدية من الأنشطة الاستثمارية</td>
                                                        <td class="text-left">{{ number_format($totalInvesting, 2) }}</td>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <!-- الأنشطة التمويلية -->
                                <div class="card mb-4">
                                    <div class="card-header bg-danger text-white">
                                        <h5 class="mb-0">الأنشطة التمويلية</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>رمز الحساب</th>
                                                        <th>اسم الحساب</th>
                                                        <th>المبلغ</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @if(count($financingActivities) > 0)
                                                        @foreach($financingActivities as $activity)
                                                            <tr>
                                                                <td>{{ $activity['code'] }}</td>
                                                                <td>{{ $activity['name'] }}</td>
                                                                <td class="text-left">{{ $activity['formatted_balance'] }}</td>
                                                            </tr>
                                                        @endforeach
                                                    @else
                                                        <tr>
                                                            <td colspan="3" class="text-center">لا توجد أنشطة تمويلية للفترة المحددة</td>
                                                        </tr>
                                                    @endif
                                                </tbody>
                                                <tfoot>
                                                    <tr class="bg-light font-weight-bold">
                                                        <td colspan="2" class="text-right">صافي التدفقات النقدية من الأنشطة التمويلية</td>
                                                        <td class="text-left">{{ number_format($totalFinancing, 2) }}</td>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <!-- ملخص النتائج -->
                                <div class="card">
                                    <div class="card-header bg-primary text-white">
                                        <h5 class="mb-0">ملخص التدفقات النقدية</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-bordered">
                                                <tbody>
                                                    <tr class="bg-success text-white">
                                                        <td>صافي التدفقات النقدية من الأنشطة التشغيلية</td>
                                                        <td class="text-left">{{ number_format($totalOperating, 2) }}</td>
                                                    </tr>
                                                    <tr class="bg-warning text-white">
                                                        <td>صافي التدفقات النقدية من الأنشطة الاستثمارية</td>
                                                        <td class="text-left">{{ number_format($totalInvesting, 2) }}</td>
                                                    </tr>
                                                    <tr class="bg-danger text-white">
                                                        <td>صافي التدفقات النقدية من الأنشطة التمويلية</td>
                                                        <td class="text-left">{{ number_format($totalFinancing, 2) }}</td>
                                                    </tr>
                                                    <tr class="bg-primary text-white font-weight-bold">
                                                        <td>إجمالي صافي التدفقات النقدية</td>
                                                        <td class="text-left">{{ number_format($totalCashFlow, 2) }}</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i> يرجى تحديد الفترة الزمنية لعرض قائمة التدفقات النقدية
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('styles')
<style>
    @media print {
        .btn, form, .card-header, .main-header, .main-sidebar, .main-footer {
            display: none !important;
        }
        .card {
            border: none !important;
            box-shadow: none !important;
        }
        .card-body {
            padding: 0 !important;
        }
        body {
            margin: 0;
            padding: 0;
            background: #fff;
        }
        .content-wrapper {
            background: #fff;
            margin: 0 !important;
            padding: 0 !important;
        }
    }
</style>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // عندما تتغير السنة المالية، يتم تحديث التواريخ
        $('#fiscal_year_id').change(function() {
            var selectedOption = $(this).find('option:selected');
            if (selectedOption.val()) {
                var dates = selectedOption.text().match(/\(([^)]+)\)/)[1].split(' - ');
                $('#start_date').val(dates[0]);
                $('#end_date').val(dates[1]);
            } else {
                $('#start_date').val('');
                $('#end_date').val('');
            }
        });
    });
</script>
@endsection