@extends('layouts.app')

@section('title', 'قائمة المركز المالي')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">قائمة المركز المالي
                        @if($date)
                            كما في {{ is_string($date) ? $date : $date->format('Y-m-d') }}
                        @endif
                    </h3>
                    <div>
                        <button onclick="window.print()" class="btn btn-info">
                            <i class="fas fa-print"></i> طباعة
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('financial-statements.balance-sheet') }}" method="GET" class="mb-4">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="fiscal_year_id">السنة المالية</label>
                                    <select class="form-control" id="fiscal_year_id" name="fiscal_year_id">
                                        <option value="">-- اختر السنة المالية --</option>
                                        @foreach($fiscalYears ?? [] as $year)
                                            <option value="{{ $year->id }}" {{ ($fiscalYearId ?? '') == $year->id ? 'selected' : '' }}>
                                                {{ $year->name }} ({{ $year->start_date->format('Y-m-d') }} - {{ $year->end_date->format('Y-m-d') }})
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="date">تاريخ المركز المالي</label>
                                    <input type="date" class="form-control" id="date" name="date" value="{{ $date ? (is_string($date) ? $date : $date->format('Y-m-d')) : '' }}">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>&nbsp;</label>
                                    <button type="submit" class="btn btn-primary btn-block">عرض</button>
                                </div>
                            </div>
                        </div>
                    </form>

                    @if($date)
                        <div class="row">
                            <div class="col-md-12">
                                <!-- قسم الأصول -->
                                <div class="card mb-4">
                                    <div class="card-header bg-success text-white">
                                        <h5 class="mb-0">الأصول</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>رمز الحساب</th>
                                                        <th>اسم الحساب</th>
                                                        <th>المبلغ</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @if(count($assets) > 0)
                                                        @foreach($assets as $asset)
                                                            <tr>
                                                                <td>{{ $asset['code'] }}</td>
                                                                <td>{{ $asset['name'] }}</td>
                                                                <td class="text-left">{{ $asset['formatted_balance'] }}</td>
                                                            </tr>
                                                        @endforeach
                                                    @else
                                                        <tr>
                                                            <td colspan="3" class="text-center">لا توجد أصول للتاريخ المحدد</td>
                                                        </tr>
                                                    @endif
                                                </tbody>
                                                <tfoot>
                                                    <tr class="bg-light font-weight-bold">
                                                        <td colspan="2" class="text-right">إجمالي الأصول</td>
                                                        <td class="text-left">{{ number_format($totalAssets, 2) }}</td>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <!-- قسم الالتزامات -->
                                <div class="card mb-4">
                                    <div class="card-header bg-danger text-white">
                                        <h5 class="mb-0">الالتزامات</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>رمز الحساب</th>
                                                        <th>اسم الحساب</th>
                                                        <th>المبلغ</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @if(count($liabilities) > 0)
                                                        @foreach($liabilities as $liability)
                                                            <tr>
                                                                <td>{{ $liability['code'] }}</td>
                                                                <td>{{ $liability['name'] }}</td>
                                                                <td class="text-left">{{ $liability['formatted_balance'] }}</td>
                                                            </tr>
                                                        @endforeach
                                                    @else
                                                        <tr>
                                                            <td colspan="3" class="text-center">لا توجد التزامات للتاريخ المحدد</td>
                                                        </tr>
                                                    @endif
                                                </tbody>
                                                <tfoot>
                                                    <tr class="bg-light font-weight-bold">
                                                        <td colspan="2" class="text-right">إجمالي الالتزامات</td>
                                                        <td class="text-left">{{ number_format($totalLiabilities, 2) }}</td>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <!-- قسم حقوق الملكية -->
                                <div class="card mb-4">
                                    <div class="card-header bg-info text-white">
                                        <h5 class="mb-0">حقوق الملكية</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>رمز الحساب</th>
                                                        <th>اسم الحساب</th>
                                                        <th>المبلغ</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @if(count($equity) > 0)
                                                        @foreach($equity as $item)
                                                            <tr>
                                                                <td>{{ $item['code'] }}</td>
                                                                <td>{{ $item['name'] }}</td>
                                                                <td class="text-left">{{ $item['formatted_balance'] }}</td>
                                                            </tr>
                                                        @endforeach
                                                    @else
                                                        <tr>
                                                            <td colspan="3" class="text-center">لا توجد حقوق ملكية للتاريخ المحدد</td>
                                                        </tr>
                                                    @endif
                                                </tbody>
                                                <tfoot>
                                                    <tr class="bg-light font-weight-bold">
                                                        <td colspan="2" class="text-right">إجمالي حقوق الملكية</td>
                                                        <td class="text-left">{{ number_format($totalEquity, 2) }}</td>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <!-- ملخص المركز المالي -->
                                <div class="card">
                                    <div class="card-header bg-primary text-white">
                                        <h5 class="mb-0">ملخص المركز المالي</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-bordered">
                                                <tbody>
                                                    <tr class="bg-success text-white">
                                                        <td>إجمالي الأصول</td>
                                                        <td class="text-left">{{ number_format($totalAssets, 2) }}</td>
                                                    </tr>
                                                    <tr class="bg-danger text-white">
                                                        <td>إجمالي الالتزامات</td>
                                                        <td class="text-left">{{ number_format($totalLiabilities, 2) }}</td>
                                                    </tr>
                                                    <tr class="bg-info text-white">
                                                        <td>إجمالي حقوق الملكية</td>
                                                        <td class="text-left">{{ number_format($totalEquity, 2) }}</td>
                                                    </tr>
                                                    <tr class="bg-primary text-white font-weight-bold">
                                                        <td>إجمالي الالتزامات وحقوق الملكية</td>
                                                        <td class="text-left">{{ number_format($totalLiabilities + $totalEquity, 2) }}</td>
                                                    </tr>
                                                    <tr class="{{ abs($totalAssets - ($totalLiabilities + $totalEquity)) < 0.01 ? 'bg-success' : 'bg-warning' }} text-white font-weight-bold">
                                                        <td>الفرق (يجب أن يكون صفر)</td>
                                                        <td class="text-left">{{ number_format($totalAssets - ($totalLiabilities + $totalEquity), 2) }}</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i> يرجى تحديد تاريخ لعرض قائمة المركز المالي
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('styles')
<style>
    @media print {
        .btn, form, .card-header, .main-header, .main-sidebar, .main-footer {
            display: none !important;
        }
        .card {
            border: none !important;
            box-shadow: none !important;
        }
        .card-body {
            padding: 0 !important;
        }
        body {
            margin: 0;
            padding: 0;
            background: #fff;
        }
        .content-wrapper {
            background: #fff;
            margin: 0 !important;
            padding: 0 !important;
        }
    }
</style>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // Cuando cambia la selección de año fiscal, actualizar la fecha
        $('#fiscal_year_id').change(function() {
            var selectedOption = $(this).find('option:selected');
            if (selectedOption.val()) {
                var dates = selectedOption.text().match(/\(([^)]+)\)/)[1].split(' - ');
                $('#date').val(dates[1]); // Usamos la fecha final del año fiscal para el balance
            } else {
                $('#date').val('');
            }
        });
    });
</script>
@endsection