@extends('layouts.app')

@section('title', 'لوحة التحكم المحاسبية')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">لوحة التحكم المحاسبية</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">الرئيسية</a></li>
                    <li class="breadcrumb-item active">لوحة التحكم المحاسبية</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <!-- إحصائيات سريعة -->
            <div class="col-lg-3 col-6">
                <div class="small-box bg-info">
                    <div class="inner">
                        <h3>{{ \App\Models\JournalEntry::where('company_id', auth()->user()->company_id)->count() }}</h3>
                        <p>القيود المحاسبية</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-book"></i>
                    </div>
                    <a href="{{ route('journal-entries.index') }}" class="small-box-footer">
                        عرض التفاصيل <i class="fas fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-6">
                <div class="small-box bg-success">
                    <div class="inner">
                        <h3>{{ \App\Models\ChartOfAccount::where('company_id', auth()->user()->company_id)->count() }}</h3>
                        <p>الحسابات</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-chart-pie"></i>
                    </div>
                    <a href="{{ route('chart-of-accounts.index') }}" class="small-box-footer">
                        عرض التفاصيل <i class="fas fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-6">
                <div class="small-box bg-warning">
                    <div class="inner">
                        <h3>{{ \App\Models\FiscalYear::where('company_id', auth()->user()->company_id)->count() }}</h3>
                        <p>السنوات المالية</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-calendar"></i>
                    </div>
                    <a href="{{ route('fiscal-years.index') }}" class="small-box-footer">
                        عرض التفاصيل <i class="fas fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-6">
                <div class="small-box bg-danger">
                    <div class="inner">
                        <h3>{{ \App\Models\JournalTemplate::where('company_id', auth()->user()->company_id)->count() }}</h3>
                        <p>قوالب القيود</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-copy"></i>
                    </div>
                    <a href="{{ route('journal-templates.index') }}" class="small-box-footer">
                        عرض التفاصيل <i class="fas fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- آخر القيود المحاسبية -->
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">آخر القيود المحاسبية</h3>
                        <div class="card-tools">
                            <a href="{{ route('journal-entries.index') }}" class="btn btn-tool">
                                <i class="fas fa-list"></i> عرض الكل
                            </a>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>الرقم</th>
                                        <th>التاريخ</th>
                                        <th>المبلغ</th>
                                        <th>الوصف</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $latestEntries = \App\Models\JournalEntry::where('company_id', auth()->user()->company_id)
                                            ->orderBy('created_at', 'desc')
                                            ->take(5)
                                            ->get();
                                    @endphp
                                    
                                    @forelse($latestEntries as $entry)
                                        <tr>
                                            <td>{{ $entry->entry_number }}</td>
                                            <td>{{ $entry->entry_date }}</td>
                                            <td>{{ number_format($entry->total_amount, 2) }}</td>
                                            <td>{{ \Illuminate\Support\Str::limit($entry->description, 30) }}</td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="4" class="text-center">لا توجد قيود محاسبية</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- الحسابات الأكثر نشاطاً -->
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">الحسابات الأكثر نشاطاً</h3>
                        <div class="card-tools">
                            <a href="{{ route('chart-of-accounts.index') }}" class="btn btn-tool">
                                <i class="fas fa-list"></i> عرض الكل
                            </a>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>رمز الحساب</th>
                                        <th>اسم الحساب</th>
                                        <th>الرصيد الحالي</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $activeAccounts = \App\Models\ChartOfAccount::where('company_id', auth()->user()->company_id)
                                            ->orderBy('current_balance', 'desc')
                                            ->take(5)
                                            ->get();
                                    @endphp
                                    
                                    @forelse($activeAccounts as $account)
                                        <tr>
                                            <td>{{ $account->account_code }}</td>
                                            <td>{{ $account->name }}</td>
                                            <td>{{ number_format($account->current_balance, 2) }}</td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="3" class="text-center">لا توجد حسابات</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- روابط سريعة -->
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">روابط سريعة</h3>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-3 col-sm-6">
                                <a href="{{ route('journal-entries.create') }}" class="btn btn-primary btn-block mb-3">
                                    <i class="fas fa-plus"></i> إنشاء قيد محاسبي جديد
                                </a>
                            </div>
                            <div class="col-md-3 col-sm-6">
                                <a href="{{ route('chart-of-accounts.create') }}" class="btn btn-success btn-block mb-3">
                                    <i class="fas fa-plus"></i> إضافة حساب جديد
                                </a>
                            </div>
                            <div class="col-md-3 col-sm-6">
                                <a href="{{ route('chart-of-accounts.trial-balance') }}" class="btn btn-info btn-block mb-3">
                                    <i class="fas fa-balance-scale"></i> ميزان المراجعة
                                </a>
                            </div>
                            <div class="col-md-3 col-sm-6">
                                <a href="{{ route('chart-of-accounts.tree') }}" class="btn btn-warning btn-block mb-3">
                                    <i class="fas fa-sitemap"></i> شجرة الحسابات
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(function () {
        // يمكن إضافة أي سكريبت خاص بلوحة التحكم المحاسبية هنا
    });
</script>
@endsection