@extends('layouts.app')

@section('title', 'ميزان المراجعة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">ميزان المراجعة كما في {{ $date }}</h3>
                    <div>
                        <a href="{{ route('chart-of-accounts.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة إلى دليل الحسابات
                        </a>
                        <button onclick="window.print()" class="btn btn-info">
                            <i class="fas fa-print"></i> طباعة
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('chart-of-accounts.trial-balance') }}" method="GET" class="mb-4">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="date">التاريخ</label>
                                    <input type="date" class="form-control" id="date" name="date" value="{{ $date }}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>&nbsp;</label>
                                    <button type="submit" class="btn btn-primary btn-block">عرض</button>
                                </div>
                            </div>
                        </div>
                    </form>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>رمز الحساب</th>
                                    <th>اسم الحساب</th>
                                    <th>نوع الحساب</th>
                                    <th>مدين</th>
                                    <th>دائن</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $totalDebit = 0;
                                    $totalCredit = 0;
                                @endphp
                                
                                @foreach($accounts as $account)
                                    @php
                                        $debit = 0;
                                        $credit = 0;
                                        $balance = $account->current_balance;
                                        
                                        // تحديد ما إذا كان الرصيد مدين أو دائن بناءً على نوع الحساب
                                        if (in_array($account->account_type, ['asset', 'expense'])) {
                                            // الأصول والمصروفات: الرصيد الموجب يكون مدين، والسالب يكون دائن
                                            if ($balance > 0) {
                                                $debit = $balance;
                                                $totalDebit += $debit;
                                            } elseif ($balance < 0) {
                                                $credit = abs($balance);
                                                $totalCredit += $credit;
                                            }
                                        } else {
                                            // الخصوم والإيرادات وحقوق الملكية: الرصيد الموجب يكون دائن، والسالب يكون مدين
                                            if ($balance > 0) {
                                                $credit = $balance;
                                                $totalCredit += $credit;
                                            } elseif ($balance < 0) {
                                                $debit = abs($balance);
                                                $totalDebit += $debit;
                                            }
                                        }
                                    @endphp
                                    
                                    @if($debit > 0 || $credit > 0)
                                    <tr>
                                        <td>{{ $account->account_code }}</td>
                                        <td>{{ $account->name }}</td>
                                        <td>
                                            @switch($account->account_type)
                                                @case('asset')
                                                    أصول
                                                    @break
                                                @case('liability')
                                                    خصوم
                                                    @break
                                                @case('equity')
                                                    حقوق ملكية
                                                    @break
                                                @case('revenue')
                                                    إيرادات
                                                    @break
                                                @case('expense')
                                                    مصروفات
                                                    @break
                                                @default
                                                    {{ $account->account_type }}
                                            @endswitch
                                        </td>
                                        <td class="text-left">{{ $debit > 0 ? number_format($debit, 2) : '-' }}</td>
                                        <td class="text-left">{{ $credit > 0 ? number_format($credit, 2) : '-' }}</td>
                                    </tr>
                                    @endif
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr class="bg-light font-weight-bold">
                                    <td colspan="3" class="text-center">الإجمالي</td>
                                    <td class="text-left">{{ number_format($totalDebit, 2) }}</td>
                                    <td class="text-left">{{ number_format($totalCredit, 2) }}</td>
                                </tr>
                                <tr class="bg-light font-weight-bold">
                                    <td colspan="3" class="text-center">الفرق</td>
                                    <td colspan="2" class="text-center">
                                        @if($totalDebit == $totalCredit)
                                            <span class="text-success">متوازن (0.00)</span>
                                        @else
                                            <span class="text-danger">غير متوازن ({{ number_format(abs($totalDebit - $totalCredit), 2) }})</span>
                                        @endif
                                    </td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('styles')
<style>
    @media print {
        .btn, form, .card-header, .main-header, .main-sidebar, .main-footer {
            display: none !important;
        }
        .card {
            border: none !important;
            box-shadow: none !important;
        }
        .card-body {
            padding: 0 !important;
        }
        body {
            margin: 0;
            padding: 0;
            background: #fff;
        }
        .content-wrapper {
            background: #fff;
            margin: 0 !important;
            padding: 0 !important;
        }
    }
</style>
@endsection