@extends('layouts.app')

@section('title', 'شجرة الحسابات')

@section('styles')
<style>
    /* تنسيق أساسي لشجرة الحسابات */
    .coa-tree {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        direction: rtl;
    }
    
    .coa-tree ul {
        list-style-type: none;
        padding: 0;
        margin: 0;
    }
    
    .coa-tree > ul {
        padding-right: 0;
    }
    
    .coa-tree li {
        position: relative;
        padding: 0;
        margin: 0;
    }
    
    /* خطوط الاتصال بين العناصر */
    .coa-tree li::before,
    .coa-tree li::after {
        content: '';
        position: absolute;
        right: -15px;
    }
    
    .coa-tree li::before {
        border-top: 1px solid #ccc;
        top: 20px;
        width: 15px;
        height: 0;
    }
    
    .coa-tree li::after {
        border-right: 1px solid #ccc;
        height: 100%;
        width: 0px;
        top: 0;
    }
    
    .coa-tree li:last-child::after {
        height: 20px;
    }
    
    .coa-tree ul ul {
        padding-right: 30px;
        margin-right: 5px;
    }
    
    /* تنسيق عناصر الحساب */
    .coa-account {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin: 5px 0;
        padding: 10px 15px;
        border-radius: 6px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.08);
        transition: all 0.3s ease;
        border-right: 4px solid transparent;
        position: relative;
        z-index: 1;
        background-color: #fff;
    }
    
    .coa-account:hover {
        box-shadow: 0 4px 8px rgba(0,0,0,0.15);
        transform: translateY(-2px);
    }
    
    /* تنسيق أيقونة التوسيع/الطي */
    .coa-toggle {
        position: absolute;
        right: -25px;
        top: 15px;
        width: 20px;
        height: 20px;
        background-color: #f8f9fa;
        border: 1px solid #dee2e6;
        border-radius: 50%;
        text-align: center;
        line-height: 18px;
        cursor: pointer;
        z-index: 2;
        font-weight: bold;
        color: #495057;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }
    
    .coa-toggle:hover {
        background-color: #e9ecef;
    }
    
    /* تنسيق معلومات الحساب */
    .coa-account-info {
        display: flex;
        align-items: center;
        flex: 1;
    }
    
    .coa-account-code {
        font-family: 'Courier New', monospace;
        font-weight: bold;
        padding: 3px 8px;
        border-radius: 4px;
        margin-left: 12px;
        background-color: #f8f9fa;
        border: 1px solid #e9ecef;
        min-width: 80px;
        text-align: center;
    }
    
    .coa-account-name {
        font-weight: 500;
        margin-right: 8px;
        flex: 1;
    }
    
    .coa-account-name a {
        color: #212529;
        text-decoration: none;
    }
    
    .coa-account-name a:hover {
        color: #007bff;
    }
    
    .coa-account-name small {
        display: block;
        color: #6c757d;
        font-size: 0.85em;
        margin-top: 2px;
    }
    
    .coa-account-balance {
        font-weight: bold;
        text-align: left;
        direction: ltr;
        padding: 3px 8px;
        border-radius: 4px;
        background-color: #f8f9fa;
        border: 1px solid #e9ecef;
    }
    
    /* تنسيق الشارات والعلامات */
    .coa-badge {
        display: inline-block;
        padding: 2px 6px;
        border-radius: 4px;
        font-size: 0.75em;
        font-weight: 600;
        margin-right: 5px;
        color: white;
    }
    
    /* تنسيق أنواع الحسابات */
    .coa-account.asset {
        border-right-color: #28a745;
        background-color: rgba(40, 167, 69, 0.03);
    }
    
    .coa-account.liability {
        border-right-color: #dc3545;
        background-color: rgba(220, 53, 69, 0.03);
    }
    
    .coa-account.equity {
        border-right-color: #ffc107;
        background-color: rgba(255, 193, 7, 0.03);
    }
    
    .coa-account.revenue {
        border-right-color: #007bff;
        background-color: rgba(0, 123, 255, 0.03);
    }
    
    .coa-account.expense {
        border-right-color: #6c757d;
        background-color: rgba(108, 117, 125, 0.03);
    }
    
    /* تنسيق الحسابات الرئيسية والفرعية */
    .coa-account.parent {
        background-color: #f0f0f0;
        font-weight: bold;
        border-left: 3px solid #343a40;
    }
    
    .coa-account.child {
        background-color: #e6f7ff;
        border-left: 3px solid #17a2b8;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
    }
    
    /* تنسيق شارات أنواع الحسابات */
    .coa-badge.asset {
        background-color: #28a745;
    }
    
    .coa-badge.liability {
        background-color: #dc3545;
    }
    
    .coa-badge.equity {
        background-color: #ffc107;
        color: #212529;
    }
    
    .coa-badge.revenue {
        background-color: #007bff;
    }
    
    .coa-badge.expense {
        background-color: #6c757d;
    }
    
    /* تنسيق نوع الرصيد */
    .coa-balance-type {
        font-size: 0.75em;
        padding: 1px 4px;
        border-radius: 3px;
        margin-left: 5px;
    }
    
    .coa-balance-type.debit {
        background-color: #e9f5e9;
        color: #28a745;
    }
    
    .coa-balance-type.credit {
        background-color: #f8d7da;
        color: #dc3545;
    }
    
    /* تنسيق الحسابات حسب المستوى */
    .coa-level-1 > .coa-account {
        font-size: 1.1em;
        font-weight: bold;
    }
    
    .coa-level-2 > .coa-account {
        font-size: 1.05em;
    }
    
    .coa-level-3 > .coa-account {
        font-size: 1em;
    }
    
    /* تنسيق الشارات الإضافية */
    .coa-tag {
        display: inline-block;
        padding: 1px 5px;
        border-radius: 3px;
        font-size: 0.7em;
        margin-right: 5px;
        background-color: #f8f9fa;
        border: 1px solid #dee2e6;
        color: #495057;
    }
    
    .coa-tag.cash {
        background-color: #d1e7dd;
        border-color: #badbcc;
        color: #0f5132;
    }
    
    .coa-tag.bank {
        background-color: #cfe2ff;
        border-color: #b6d4fe;
        color: #084298;
    }
    
    .coa-tag.inactive {
        background-color: #f8d7da;
        border-color: #f5c2c7;
        color: #842029;
    }
    
    .coa-tag.system {
        background-color: #e2e3e5;
        border-color: #d3d6d8;
        color: #41464b;
    }
    
    /* تنسيق أدوات التصفية */
    .coa-filters {
        margin-bottom: 20px;
    }
    
    .coa-search {
        position: relative;
    }
    
    .coa-search input {
        padding-right: 35px;
    }
    
    .coa-search i {
        position: absolute;
        right: 10px;
        top: 10px;
        color: #6c757d;
    }
    
    /* تنسيق دليل الألوان */
    .coa-legend {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
        margin-bottom: 15px;
    }
    
    .coa-legend-item {
        display: flex;
        align-items: center;
        padding: 5px 10px;
        border-radius: 4px;
        background-color: #f8f9fa;
        font-size: 0.85em;
    }
    
    .coa-legend-color {
        width: 15px;
        height: 15px;
        border-radius: 3px;
        margin-left: 5px;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">شجرة الحسابات</h3>
                    <div>
                        <a href="{{ route('chart-of-accounts.index') }}" class="btn btn-secondary">
                            <i class="fas fa-list"></i> عرض قائمة الحسابات
                        </a>
                        @can('create_chart_of_accounts')
                        <a href="{{ route('chart-of-accounts.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> إضافة حساب جديد
                        </a>
                        @endcan
                    </div>
                </div>
                <div class="card-body">
                    <!-- أدوات التصفية والبحث -->
                    <div class="row mb-4">
                        <div class="col-md-7">
                            <div class="coa-filters">
                                <div class="btn-group mb-3" role="group">
                                    <button type="button" class="btn btn-outline-secondary" id="expand-all">
                                        <i class="fas fa-expand-arrows-alt"></i> توسيع الكل
                                    </button>
                                    <button type="button" class="btn btn-outline-secondary" id="collapse-all">
                                        <i class="fas fa-compress-arrows-alt"></i> طي الكل
                                    </button>
                                </div>
                                <div class="btn-group mb-3 mr-2" role="group">
                                    <button type="button" class="btn btn-outline-success filter-btn" data-type="asset">
                                        <i class="fas fa-coins"></i> أصول
                                    </button>
                                    <button type="button" class="btn btn-outline-danger filter-btn" data-type="liability">
                                        <i class="fas fa-hand-holding-usd"></i> خصوم
                                    </button>
                                    <button type="button" class="btn btn-outline-warning filter-btn" data-type="equity">
                                        <i class="fas fa-balance-scale"></i> حقوق ملكية
                                    </button>
                                    <button type="button" class="btn btn-outline-primary filter-btn" data-type="revenue">
                                        <i class="fas fa-chart-line"></i> إيرادات
                                    </button>
                                    <button type="button" class="btn btn-outline-secondary filter-btn" data-type="expense">
                                        <i class="fas fa-shopping-cart"></i> مصروفات
                                    </button>
                                    <button type="button" class="btn btn-outline-dark filter-btn active" data-type="all">
                                        <i class="fas fa-list"></i> الكل
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="coa-search">
                                <i class="fas fa-search"></i>
                                <input type="text" class="form-control" id="account-search" placeholder="بحث في الحسابات (الاسم، الكود، الوصف)">
                            </div>
                        </div>
                    </div>

                    <!-- دليل الألوان -->
                    <div class="card bg-light mb-4">
                        <div class="card-body p-3">
                            <h5 class="card-title mb-3">دليل شجرة الحسابات</h5>
                            
                            <div class="row mb-3">
                                <div class="col-md-12">
                                    <h6 class="mb-2">أنواع الحسابات</h6>
                                    <div class="coa-legend">
                                        <div class="coa-legend-item">
                                            <div class="coa-legend-color" style="background-color: #28a745;"></div>
                                            <span>أصول</span>
                                        </div>
                                        <div class="coa-legend-item">
                                            <div class="coa-legend-color" style="background-color: #dc3545;"></div>
                                            <span>خصوم</span>
                                        </div>
                                        <div class="coa-legend-item">
                                            <div class="coa-legend-color" style="background-color: #ffc107;"></div>
                                            <span>حقوق ملكية</span>
                                        </div>
                                        <div class="coa-legend-item">
                                            <div class="coa-legend-color" style="background-color: #007bff;"></div>
                                            <span>إيرادات</span>
                                        </div>
                                        <div class="coa-legend-item">
                                            <div class="coa-legend-color" style="background-color: #6c757d;"></div>
                                            <span>مصروفات</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row mb-3">
                                <div class="col-md-12">
                                    <h6 class="mb-2">تصنيف الحسابات</h6>
                                    <div class="coa-legend">
                                        <div class="coa-legend-item">
                                            <div class="coa-legend-color" style="background-color: #f0f0f0; border-left: 3px solid #343a40;"></div>
                                            <span>حساب رئيسي (أب)</span>
                                        </div>
                                        <div class="coa-legend-item">
                                            <div class="coa-legend-color" style="background-color: #e6f7ff; border-left: 3px solid #17a2b8;"></div>
                                            <span>حساب فرعي</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-12">
                                    <h6 class="mb-2">مستويات الحسابات</h6>
                                    <div class="coa-legend">
                                        <div class="coa-legend-item" style="background-color: rgba(0, 0, 0, 0.02); font-weight: bold;">
                                            <span>حساب رئيسي</span>
                                        </div>
                                        <div class="coa-legend-item" style="background-color: rgba(255, 255, 255, 0.8);">
                                            <span>حساب فرعي</span>
                                        </div>
                                        <div class="coa-legend-item">
                                            <div class="coa-balance-type debit">مدين</div>
                                            <span>رصيد مدين</span>
                                        </div>
                                        <div class="coa-legend-item">
                                            <div class="coa-balance-type credit">دائن</div>
                                            <span>رصيد دائن</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- شجرة الحسابات -->
                    <div class="coa-tree">
                        <ul>
                            @foreach($accounts as $account)
                                @include('accounting.chart_of_accounts.partials.account_tree_item_new', ['account' => $account, 'level' => 1])
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        // تطبيق تأثيرات بصرية عند تحميل الصفحة
        $('.coa-account').each(function(index) {
            $(this).css('opacity', 0);
            $(this).delay(index * 30).animate({
                opacity: 1
            }, 300);
        });

        // توسيع وطي الشجرة
        $('.coa-toggle').on('click', function() {
            var $parent = $(this).closest('li');
            var $ul = $parent.find('> ul');
            
            if ($ul.is(':visible')) {
                $ul.slideUp(200);
                $(this).text('+');
            } else {
                $ul.slideDown(200);
                $(this).text('-');
            }
        });

        // توسيع الكل
        $('#expand-all').on('click', function() {
            $('.coa-tree ul').slideDown(300);
            $('.coa-toggle').text('-');
        });

        // طي الكل
        $('#collapse-all').on('click', function() {
            $('.coa-tree ul').slideUp(300);
            $('.coa-toggle').text('+');
        });

        // تصفية حسب النوع
        $('.filter-btn').on('click', function() {
            // إزالة الفئة النشطة من جميع الأزرار
            $('.filter-btn').removeClass('active');
            // إضافة الفئة النشطة للزر المحدد
            $(this).addClass('active');
            
            var type = $(this).data('type');
            
            if (type === 'all') {
                $('.coa-account').closest('li').fadeIn(300);
            } else {
                $('.coa-account').closest('li').hide();
                $('.coa-account.' + type).closest('li').fadeIn(300);
                
                // إظهار الآباء للعناصر المطابقة
                $('.coa-account.' + type).parents('li').fadeIn(300);
                $('.coa-account.' + type).parents('li').find('> ul').show();
                $('.coa-account.' + type).parents('li').find('> .coa-toggle').text('-');
            }
        });
        
        // تطبيق تأثير البحث
        $('#account-search').on('keyup', function() {
            var searchText = $(this).val().toLowerCase();
            
            if (searchText.length > 0) {
                $('.coa-account').each(function() {
                    var accountName = $(this).find('.coa-account-name').text().toLowerCase();
                    var accountCode = $(this).find('.coa-account-code').text().toLowerCase();
                    var accountNameEn = $(this).find('small').text().toLowerCase();
                    
                    if (accountName.indexOf(searchText) > -1 || 
                        accountCode.indexOf(searchText) > -1 || 
                        accountNameEn.indexOf(searchText) > -1) {
                        $(this).closest('li').show();
                        // توسيع الآباء للعناصر المطابقة
                        $(this).closest('li').parents('li').show();
                        $(this).closest('li').parents('ul').show();
                        $(this).closest('li').parents('li').find('> .coa-toggle').text('-');
                    } else {
                        $(this).closest('li').hide();
                    }
                });
            } else {
                // إذا كان حقل البحث فارغًا، أظهر جميع العناصر
                $('.coa-account').closest('li').show();
            }
        });
        
        // إضافة تأثيرات حركية عند التمرير فوق العناصر
        $('.coa-account').hover(
            function() {
                $(this).find('.coa-account-code').css({
                    'transform': 'scale(1.05)',
                    'transition': 'transform 0.2s ease'
                });
            },
            function() {
                $(this).find('.coa-account-code').css({
                    'transform': 'scale(1)',
                    'transition': 'transform 0.2s ease'
                });
            }
        );
    });
</script>
@endpush