@extends('layouts.app')

@section('title', 'شجرة الحسابات')

@section('styles')
<link rel="stylesheet" href="{{ asset('css/chart-of-accounts-tree.css') }}">
<link rel="stylesheet" href="{{ asset('css/chart-of-accounts-tree-fix.css') }}">
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">شجرة الحسابات</h3>
                    <div>
                        <a href="{{ route('chart-of-accounts.index') }}" class="btn btn-secondary">
                            <i class="fas fa-list"></i> عرض قائمة الحسابات
                        </a>
                        @can('create_chart_of_accounts')
                        <a href="{{ route('chart-of-accounts.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> إضافة حساب جديد
                        </a>
                        @endcan
                    </div>
                </div>
                <div class="card-body">
                    <!-- أدوات التصفية والبحث -->
                    <div class="row mb-4">
                        <div class="col-md-7">
                            <div class="coa-filters">
                                <div class="btn-group mb-3" role="group">
                                    <button type="button" class="btn btn-outline-secondary" id="expand-all">
                                        <i class="fas fa-expand-arrows-alt"></i> توسيع الكل
                                    </button>
                                    <button type="button" class="btn btn-outline-secondary" id="collapse-all">
                                        <i class="fas fa-compress-arrows-alt"></i> طي الكل
                                    </button>
                                </div>
                                <div class="btn-group mb-3 mr-2" role="group">
                                    <button type="button" class="btn btn-outline-success filter-btn" data-type="asset">
                                        <i class="fas fa-coins"></i> أصول
                                    </button>
                                    <button type="button" class="btn btn-outline-danger filter-btn" data-type="liability">
                                        <i class="fas fa-hand-holding-usd"></i> خصوم
                                    </button>
                                    <button type="button" class="btn btn-outline-warning filter-btn" data-type="equity">
                                        <i class="fas fa-balance-scale"></i> حقوق ملكية
                                    </button>
                                    <button type="button" class="btn btn-outline-primary filter-btn" data-type="revenue">
                                        <i class="fas fa-chart-line"></i> إيرادات
                                    </button>
                                    <button type="button" class="btn btn-outline-secondary filter-btn" data-type="expense">
                                        <i class="fas fa-shopping-cart"></i> مصروفات
                                    </button>
                                    <button type="button" class="btn btn-outline-dark filter-btn active" data-type="all">
                                        <i class="fas fa-list"></i> الكل
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="coa-search">
                                <i class="fas fa-search"></i>
                                <input type="text" class="form-control" id="account-search" placeholder="بحث في الحسابات (الاسم، الكود، الوصف)">
                            </div>
                        </div>
                    </div>

                    <!-- دليل الألوان -->
                    <div class="card bg-light mb-4">
                        <div class="card-body p-3">
                            <h5 class="card-title mb-3">دليل شجرة الحسابات</h5>
                            
                            <div class="row mb-3">
                                <div class="col-md-12">
                                    <h6 class="mb-2">أنواع الحسابات</h6>
                                    <div class="coa-legend">
                                        <div class="coa-legend-item">
                                            <div class="coa-legend-color" style="background-color: #28a745;"></div>
                                            <span>أصول</span>
                                        </div>
                                        <div class="coa-legend-item">
                                            <div class="coa-legend-color" style="background-color: #dc3545;"></div>
                                            <span>خصوم</span>
                                        </div>
                                        <div class="coa-legend-item">
                                            <div class="coa-legend-color" style="background-color: #ffc107;"></div>
                                            <span>حقوق ملكية</span>
                                        </div>
                                        <div class="coa-legend-item">
                                            <div class="coa-legend-color" style="background-color: #007bff;"></div>
                                            <span>إيرادات</span>
                                        </div>
                                        <div class="coa-legend-item">
                                            <div class="coa-legend-color" style="background-color: #6c757d;"></div>
                                            <span>مصروفات</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-12">
                                    <h6 class="mb-2">أنواع الأرصدة</h6>
                                    <div class="coa-legend">
                                        <div class="coa-legend-item">
                                            <span class="coa-balance-type debit">مدين</span>
                                            <span class="mr-1">رصيد مدين</span>
                                        </div>
                                        <div class="coa-legend-item">
                                            <span class="coa-balance-type credit">دائن</span>
                                            <span class="mr-1">رصيد دائن</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- شجرة الحسابات -->
                    <div class="coa-tree-container" style="width: 100% !important; max-width: 100% !important; overflow-x: auto !important; direction: rtl !important; padding: 20px 0 !important; box-sizing: border-box !important;">
                        <ul class="coa-tree" style="list-style-type: none !important; padding: 0 !important; margin: 0 !important; width: 100% !important; min-width: 600px !important; box-sizing: border-box !important; position: relative !important; padding-right: 20px !important;">
                            @foreach($accounts as $account)
                                @include('accounting.chart_of_accounts.partials.account_tree_item_modern', ['account' => $account, 'level' => 1])
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="{{ asset('js/chart-of-accounts-tree.js') }}"></script>
@endpush