@extends('layouts.app')

@section('title', 'شجرة الحسابات')

@section('styles')
<style>
    .account-tree {
        list-style-type: none;
        padding-right: 20px;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }
    .account-tree ul {
        list-style-type: none;
        padding-right: 30px;
        margin-top: 5px;
        border-right: 1px dashed #ccc;
    }
    .account-tree li {
        margin: 10px 0;
        position: relative;
    }
    .account-tree .toggle {
        cursor: pointer;
        position: absolute;
        right: -20px;
        top: 0;
        width: 20px;
        height: 20px;
        text-align: center;
        line-height: 20px;
        background-color: #f0f0f0;
        border-radius: 50%;
        font-weight: bold;
        color: #555;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }
    .account-tree .toggle:hover {
        background-color: #e0e0e0;
    }
    .account-tree .account-item {
        padding: 10px 15px;
        border-radius: 5px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        transition: all 0.2s ease;
        border-right: 4px solid transparent;
    }
    .account-tree .account-item:hover {
        box-shadow: 0 3px 6px rgba(0,0,0,0.15);
        transform: translateY(-2px);
    }
    .account-tree .account-code {
        font-weight: bold;
        margin-left: 10px;
        background-color: rgba(0,0,0,0.05);
        padding: 2px 6px;
        border-radius: 3px;
        font-family: monospace;
    }
    .account-tree .account-balance {
        margin-right: 15px;
        font-weight: bold;
    }
    .account-tree .account-name {
        font-weight: 500;
        margin-right: 5px;
    }
    .account-tree .account-type-label {
        font-size: 0.8em;
        padding: 2px 6px;
        border-radius: 3px;
        margin-right: 5px;
        color: white;
    }
    
    /* تنسيق أنواع الحسابات */
    .account-tree .asset { 
        background-color: rgba(40, 167, 69, 0.05); 
        border-right-color: #28a745;
    }
    .account-tree .asset .account-type-label {
        background-color: #28a745;
    }
    
    .account-tree .liability { 
        background-color: rgba(220, 53, 69, 0.05); 
        border-right-color: #dc3545;
    }
    .account-tree .liability .account-type-label {
        background-color: #dc3545;
    }
    
    .account-tree .equity { 
        background-color: rgba(255, 193, 7, 0.05); 
        border-right-color: #ffc107;
    }
    .account-tree .equity .account-type-label {
        background-color: #ffc107;
        color: #333;
    }
    
    .account-tree .revenue { 
        background-color: rgba(0, 123, 255, 0.05); 
        border-right-color: #007bff;
    }
    .account-tree .revenue .account-type-label {
        background-color: #007bff;
    }
    
    .account-tree .expense { 
        background-color: rgba(108, 117, 125, 0.05); 
        border-right-color: #6c757d;
    }
    .account-tree .expense .account-type-label {
        background-color: #6c757d;
    }
    
    /* تنسيق الحسابات الفرعية */
    .account-tree .child-account {
        background-color: rgba(255, 255, 255, 0.7);
        box-shadow: 0 1px 3px rgba(0,0,0,0.15);
    }
    
    /* تنسيق الحسابات الأب */
    .account-tree .parent-account {
        background-color: rgba(0, 0, 0, 0.03);
        font-weight: bold;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    
    /* تنسيق نوع الرصيد */
    .balance-type {
        font-size: 0.75em;
        padding: 1px 4px;
        border-radius: 3px;
        margin-right: 5px;
    }
    .balance-type.debit {
        background-color: #e9f5e9;
        color: #28a745;
    }
    .balance-type.credit {
        background-color: #f8d7da;
        color: #dc3545;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">شجرة الحسابات</h3>
                    <div>
                        <a href="{{ route('chart-of-accounts.index') }}" class="btn btn-secondary">
                            <i class="fas fa-list"></i> عرض قائمة الحسابات
                        </a>
                        @can('create_chart_of_accounts')
                        <a href="{{ route('chart-of-accounts.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> إضافة حساب جديد
                        </a>
                        @endcan
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="btn-group mb-3" role="group">
                                <button type="button" class="btn btn-outline-secondary" id="expand-all">
                                    <i class="fas fa-expand-arrows-alt"></i> توسيع الكل
                                </button>
                                <button type="button" class="btn btn-outline-secondary" id="collapse-all">
                                    <i class="fas fa-compress-arrows-alt"></i> طي الكل
                                </button>
                            </div>
                            <div class="btn-group mb-3" role="group">
                                <button type="button" class="btn btn-outline-success filter-btn" data-type="asset">
                                    <i class="fas fa-coins"></i> أصول
                                </button>
                                <button type="button" class="btn btn-outline-danger filter-btn" data-type="liability">
                                    <i class="fas fa-hand-holding-usd"></i> خصوم
                                </button>
                                <button type="button" class="btn btn-outline-warning filter-btn" data-type="equity">
                                    <i class="fas fa-balance-scale"></i> حقوق ملكية
                                </button>
                                <button type="button" class="btn btn-outline-primary filter-btn" data-type="revenue">
                                    <i class="fas fa-chart-line"></i> إيرادات
                                </button>
                                <button type="button" class="btn btn-outline-secondary filter-btn" data-type="expense">
                                    <i class="fas fa-shopping-cart"></i> مصروفات
                                </button>
                                <button type="button" class="btn btn-outline-dark filter-btn active" data-type="all">
                                    <i class="fas fa-list"></i> الكل
                                </button>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fas fa-search"></i></span>
                                    </div>
                                    <input type="text" class="form-control" id="account-search" placeholder="بحث في الحسابات (الاسم، الكود، الوصف)">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-12">
                            <div class="card bg-light">
                                <div class="card-body p-3">
                                    <h5 class="card-title mb-3">دليل الألوان</h5>
                                    <div class="row">
                                        <div class="col-md-2 mb-2">
                                            <span class="badge" style="background-color: #28a745; color: white; padding: 5px 10px;">أصول</span>
                                        </div>
                                        <div class="col-md-2 mb-2">
                                            <span class="badge" style="background-color: #dc3545; color: white; padding: 5px 10px;">خصوم</span>
                                        </div>
                                        <div class="col-md-2 mb-2">
                                            <span class="badge" style="background-color: #ffc107; color: #333; padding: 5px 10px;">حقوق ملكية</span>
                                        </div>
                                        <div class="col-md-2 mb-2">
                                            <span class="badge" style="background-color: #007bff; color: white; padding: 5px 10px;">إيرادات</span>
                                        </div>
                                        <div class="col-md-2 mb-2">
                                            <span class="badge" style="background-color: #6c757d; color: white; padding: 5px 10px;">مصروفات</span>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="row mt-2">
                                        <div class="col-md-3 mb-2">
                                            <div style="background-color: rgba(0, 0, 0, 0.03); padding: 5px 10px; border-radius: 4px; font-weight: bold;">حساب أب</div>
                                        </div>
                                        <div class="col-md-3 mb-2">
                                            <div style="background-color: rgba(255, 255, 255, 0.7); padding: 5px 10px; border-radius: 4px; box-shadow: 0 1px 3px rgba(0,0,0,0.15);">حساب فرعي</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="account-tree-container">
                        <ul class="account-tree">
                            @foreach($accounts as $account)
                                @include('accounting.chart_of_accounts.partials.account_tree_item', ['account' => $account])
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        // تطبيق تأثيرات بصرية عند تحميل الصفحة
        $('.account-item').each(function() {
            $(this).css('opacity', 0);
            $(this).animate({
                opacity: 1
            }, 500);
        });

        // توسيع وطي الشجرة
        $('.toggle').on('click', function() {
            var $parent = $(this).parent();
            var $ul = $parent.find('> ul');
            
            if ($ul.is(':visible')) {
                $ul.slideUp(200);
                $(this).text('+');
            } else {
                $ul.slideDown(200);
                $(this).text('-');
            }
        });

        // توسيع الكل
        $('#expand-all').on('click', function() {
            $('.account-tree ul').slideDown(300);
            $('.toggle').text('-');
        });

        // طي الكل
        $('#collapse-all').on('click', function() {
            $('.account-tree ul').slideUp(300);
            $('.toggle').text('+');
        });

        // تصفية حسب النوع
        $('.filter-btn').on('click', function() {
            // إزالة الفئة النشطة من جميع الأزرار
            $('.filter-btn').removeClass('active');
            // إضافة الفئة النشطة للزر المحدد
            $(this).addClass('active');
            
            var type = $(this).data('type');
            
            if (type === 'all') {
                $('.account-item').parent().fadeIn(300);
            } else {
                $('.account-item').parent().hide();
                $('.account-item.' + type).parent().fadeIn(300);
            }
        });
        
        // إضافة تأثير عند التمرير فوق عناصر الحساب
        $('.account-item').hover(
            function() {
                $(this).find('.account-code').css('transform', 'scale(1.1)');
            },
            function() {
                $(this).find('.account-code').css('transform', 'scale(1)');
            }
        );
        
        // تطبيق تأثير البحث
        $('#account-search').on('keyup', function() {
            var searchText = $(this).val().toLowerCase();
            
            if (searchText.length > 0) {
                $('.account-item').each(function() {
                    var accountName = $(this).find('.account-name').text().toLowerCase();
                    var accountCode = $(this).find('.account-code').text().toLowerCase();
                    var accountNameEn = $(this).find('small').text().toLowerCase();
                    
                    if (accountName.indexOf(searchText) > -1 || 
                        accountCode.indexOf(searchText) > -1 || 
                        accountNameEn.indexOf(searchText) > -1) {
                        $(this).parent().show();
                        // توسيع الآباء للعناصر المطابقة
                        $(this).parents('li').show();
                        $(this).parents('ul').show();
                        $(this).parents('li').find('> .toggle').text('-');
                    } else {
                        $(this).parent().hide();
                    }
                });
            } else {
                $('.account-item').parent().show();
            }
        });
    });
</script>
@endpush