@extends('layouts.app')

@section('title', 'تفاصيل الحساب')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">تفاصيل الحساب: {{ $account->name }}</h3>
                    <div>
                        @can('edit_chart_of_accounts')
                        <a href="{{ route('chart-of-accounts.edit', $account->id) }}" class="btn btn-primary">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        @endcan
                        <a href="{{ route('chart-of-accounts.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة إلى القائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">معلومات الحساب</h4>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">رمز الحساب</th>
                                            <td>{{ $account->account_code }}</td>
                                        </tr>
                                        <tr>
                                            <th>اسم الحساب</th>
                                            <td>{{ $account->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>اسم الحساب (بالإنجليزية)</th>
                                            <td>{{ $account->name_en ?? '-' }}</td>
                                        </tr>
                                        <tr>
                                            <th>نوع الحساب</th>
                                            <td>
                                                @switch($account->account_type)
                                                    @case('asset')
                                                        أصول
                                                        @break
                                                    @case('liability')
                                                        خصوم
                                                        @break
                                                    @case('equity')
                                                        حقوق ملكية
                                                        @break
                                                    @case('revenue')
                                                        إيرادات
                                                        @break
                                                    @case('expense')
                                                        مصروفات
                                                        @break
                                                    @default
                                                        {{ $account->account_type }}
                                                @endswitch
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>النوع الفرعي</th>
                                            <td>{{ $account->sub_type ?? '-' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الحساب الأب</th>
                                            <td>
                                                @if($account->parent)
                                                    <a href="{{ route('chart-of-accounts.show', $account->parent->id) }}">
                                                        {{ $account->parent->account_code }} - {{ $account->parent->name }}
                                                    </a>
                                                @else
                                                    -
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>المستوى</th>
                                            <td>{{ $account->level }}</td>
                                        </tr>
                                        <tr>
                                            <th>الوصف</th>
                                            <td>{{ $account->description ?? '-' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">معلومات الرصيد</h4>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">الرصيد الافتتاحي</th>
                                            <td>{{ number_format($account->opening_balance, 2) }} {{ $account->currency }}</td>
                                        </tr>
                                        <tr>
                                            <th>الرصيد الحالي</th>
                                            <td>{{ number_format($account->current_balance, 2) }} {{ $account->currency }}</td>
                                        </tr>
                                        <tr>
                                            <th>نوع الرصيد</th>
                                            <td>{{ $account->balance_type == 'debit' ? 'مدين' : 'دائن' }}</td>
                                        </tr>
                                        <tr>
                                            <th>العملة</th>
                                            <td>{{ $account->currency }}</td>
                                        </tr>
                                        <tr>
                                            <th>حساب نقدي</th>
                                            <td>{{ $account->is_cash_account ? 'نعم' : 'لا' }}</td>
                                        </tr>
                                        <tr>
                                            <th>حساب بنكي</th>
                                            <td>{{ $account->is_bank_account ? 'نعم' : 'لا' }}</td>
                                        </tr>
                                        <tr>
                                            <th>يسمح بالقيود</th>
                                            <td>{{ $account->allow_entries ? 'نعم' : 'لا' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @if($account->is_active)
                                                    <span class="badge badge-success">نشط</span>
                                                @else
                                                    <span class="badge badge-danger">غير نشط</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>حساب نظامي</th>
                                            <td>{{ $account->is_system ? 'نعم' : 'لا' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    @if($account->children && $account->children->count() > 0)
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">الحسابات الفرعية</h4>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>رمز الحساب</th>
                                                    <th>اسم الحساب</th>
                                                    <th>نوع الحساب</th>
                                                    <th>الرصيد الحالي</th>
                                                    <th>الحالة</th>
                                                    <th>الإجراءات</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($account->children as $child)
                                                <tr>
                                                    <td>{{ $child->account_code }}</td>
                                                    <td>{{ $child->name }}</td>
                                                    <td>
                                                        @switch($child->account_type)
                                                            @case('asset')
                                                                أصول
                                                                @break
                                                            @case('liability')
                                                                خصوم
                                                                @break
                                                            @case('equity')
                                                                حقوق ملكية
                                                                @break
                                                            @case('revenue')
                                                                إيرادات
                                                                @break
                                                            @case('expense')
                                                                مصروفات
                                                                @break
                                                            @default
                                                                {{ $child->account_type }}
                                                        @endswitch
                                                    </td>
                                                    <td class="text-left">{{ number_format($child->current_balance, 2) }} {{ $child->currency }}</td>
                                                    <td>
                                                        @if($child->is_active)
                                                            <span class="badge badge-success">نشط</span>
                                                        @else
                                                            <span class="badge badge-danger">غير نشط</span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        <a href="{{ route('chart-of-accounts.show', $child->id) }}" class="btn btn-sm btn-info">
                                                            <i class="fas fa-eye"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    @if(isset($account->journalItems) && $account->journalItems->count() > 0)
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">آخر الحركات المحاسبية</h4>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>التاريخ</th>
                                                    <th>رقم القيد</th>
                                                    <th>البيان</th>
                                                    <th>مدين</th>
                                                    <th>دائن</th>
                                                    <th>الإجراءات</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($account->journalItems as $item)
                                                <tr>
                                                    <td>{{ $item->journalEntry->date->format('Y-m-d') }}</td>
                                                    <td>{{ $item->journalEntry->reference }}</td>
                                                    <td>{{ $item->description }}</td>
                                                    <td class="text-left">{{ $item->debit > 0 ? number_format($item->debit, 2) : '' }}</td>
                                                    <td class="text-left">{{ $item->credit > 0 ? number_format($item->credit, 2) : '' }}</td>
                                                    <td>
                                                        <a href="{{ route('journal-entries.show', $item->journalEntry->id) }}" class="btn btn-sm btn-info">
                                                            <i class="fas fa-eye"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection