<li class="coa-level-{{ $level }}">
    @if($account->children && $account->children->count() > 0)
        <span class="coa-toggle">-</span>
    @endif
    
    <div class="coa-account {{ $account->account_type }} {{ $account->is_parent ? 'parent' : 'child' }}" 
         @if(!$account->is_parent) title="حساب فرعي" @else title="حساب رئيسي" @endif>
        <div class="coa-account-info">
            <span class="coa-account-code">{{ $account->account_code }}</span>
            <div class="coa-account-name">
                <a href="{{ route('chart-of-accounts.show', $account->id) }}">
                    @if(!$account->is_parent)
                        <i class="fas fa-level-down-alt" style="color: #17a2b8; margin-left: 5px;"></i>
                    @else
                        <i class="fas fa-folder" style="color: #343a40; margin-left: 5px;"></i>
                    @endif
                    {{ $account->name }}
                </a>
                @if($account->name_en)
                    <small>{{ $account->name_en }}</small>
                @endif
            </div>
            
            <span class="coa-badge {{ $account->account_type }}">
                @switch($account->account_type)
                    @case('asset')
                        أصول
                        @break
                    @case('liability')
                        خصوم
                        @break
                    @case('equity')
                        حقوق ملكية
                        @break
                    @case('revenue')
                        إيرادات
                        @break
                    @case('expense')
                        مصروفات
                        @break
                    @default
                        {{ $account->account_type }}
                @endswitch
            </span>
            
            @if(!$account->is_active)
                <span class="coa-tag inactive">غير نشط</span>
            @endif
            
            @if($account->is_system)
                <span class="coa-tag system">نظام</span>
            @endif
            
            @if($account->is_cash_account)
                <span class="coa-tag cash">نقدي</span>
            @endif
            
            @if($account->is_bank_account)
                <span class="coa-tag bank">بنكي</span>
            @endif
        </div>
        
        <div class="coa-account-balance">
            @if(isset($account->balance_type))
                <span class="coa-balance-type {{ $account->balance_type }}">
                    {{ $account->balance_type == 'debit' ? 'مدين' : 'دائن' }}
                </span>
            @endif
            {{ number_format($account->current_balance ?? 0, 2) }} {{ $account->currency ?? 'SAR' }}
        </div>
    </div>
    
    @if($account->children && $account->children->count() > 0)
        <ul>
            @foreach($account->children as $child)
                @include('accounting.chart_of_accounts.partials.account_tree_item_new', ['account' => $child, 'level' => $level + 1])
            @endforeach
        </ul>
    @endif
</li>