<li class="coa-level-{{ $level }}" style="position: relative !important; padding: 0 !important; margin: 8px 0 !important; box-sizing: border-box !important;">
    @if($account->children && $account->children->count() > 0)
        <span class="coa-toggle" style="position: absolute !important; right: -30px !important; top: 15px !important; width: 20px !important; height: 20px !important; background-color: #f8f9fa !important; border: 1px solid #dee2e6 !important; border-radius: 50% !important; text-align: center !important; line-height: 18px !important; cursor: pointer !important; z-index: 5 !important;">-</span>
    @endif
    <!-- خط اتصال أفقي -->
    <span style="position: absolute !important; right: -20px !important; top: 20px !important; width: 20px !important; height: 1px !important; background-color: #ccc !important; z-index: 1 !important;"></span>
    
    <div class="coa-account {{ $account->account_type }} {{ $account->is_parent ? 'parent' : 'child' }}" style="display: flex !important; justify-content: space-between !important; align-items: center !important; margin: 5px 0 !important; padding: 12px 15px !important; border-radius: 6px !important; box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1) !important; border-right: 4px solid transparent !important; background-color: #fff !important; position: relative !important; z-index: 1 !important; width: 100% !important; box-sizing: border-box !important; overflow: hidden !important;">
        <div class="coa-account-info" style="display: flex !important; align-items: center !important; flex: 1 !important; overflow: hidden !important;">
            <div style="display: flex !important; align-items: center !important; margin-left: 12px !important; flex-wrap: nowrap !important; width: auto !important;">
                <span class="coa-account-code" style="font-family: 'Courier New', monospace !important; font-weight: bold !important; padding: 4px 8px !important; border-radius: 4px !important; margin-left: 0 !important; background-color: #f8f9fa !important; border: 1px solid #e9ecef !important; min-width: 80px !important; text-align: center !important; display: inline-block !important;">{{ $account->account_code }}</span>
                <span class="coa-account-name" style="font-weight: 500 !important; margin-right: 8px !important; margin-left: 8px !important; overflow: hidden !important; text-overflow: ellipsis !important; white-space: nowrap !important; display: inline-block !important;">
                    <a href="{{ route('chart-of-accounts.show', $account->id) }}">{{ $account->name }}</a>
                    @if($account->name_en)
                        <small style="display: block !important; color: #6c757d !important; font-size: 0.85em !important; margin-top: 2px !important;">{{ $account->name_en }}</small>
                    @endif
                </span>
            </div>
            
            <span class="coa-badge {{ $account->account_type }}" style="display: inline-block !important; padding: 2px 6px !important; border-radius: 4px !important; font-size: 0.75em !important; font-weight: 600 !important; margin-right: 5px !important; color: white !important; background-color: 
                @switch($account->account_type)
                    @case('asset')
                        #28a745
                        @break
                    @case('liability')
                        #dc3545
                        @break
                    @case('equity')
                        #ffc107
                        @break
                    @case('revenue')
                        #007bff
                        @break
                    @case('expense')
                        #6c757d
                        @break
                    @default
                        #6c757d
                @endswitch
            !important;">
                @switch($account->account_type)
                    @case('asset')
                        أصول
                        @break
                    @case('liability')
                        خصوم
                        @break
                    @case('equity')
                        حقوق ملكية
                        @break
                    @case('revenue')
                        إيرادات
                        @break
                    @case('expense')
                        مصروفات
                        @break
                    @default
                        {{ $account->account_type }}
                @endswitch
            </span>
            
            @if(!$account->is_active)
                <span class="coa-tag inactive" style="display: inline-block !important; padding: 1px 5px !important; border-radius: 3px !important; font-size: 0.7em !important; margin-right: 5px !important; background-color: #f8d7da !important; border: 1px solid #f5c2c7 !important; color: #842029 !important;">غير نشط</span>
            @endif
            
            @if($account->is_system)
                <span class="coa-tag system" style="display: inline-block !important; padding: 1px 5px !important; border-radius: 3px !important; font-size: 0.7em !important; margin-right: 5px !important; background-color: #e2e3e5 !important; border: 1px solid #d3d6d8 !important; color: #41464b !important;">نظام</span>
            @endif
            
            @if($account->is_cash_account)
                <span class="coa-tag cash" style="display: inline-block !important; padding: 1px 5px !important; border-radius: 3px !important; font-size: 0.7em !important; margin-right: 5px !important; background-color: #d1e7dd !important; border: 1px solid #badbcc !important; color: #0f5132 !important;">نقدي</span>
            @endif
            
            @if($account->is_bank_account)
                <span class="coa-tag bank" style="display: inline-block !important; padding: 1px 5px !important; border-radius: 3px !important; font-size: 0.7em !important; margin-right: 5px !important; background-color: #cfe2ff !important; border: 1px solid #b6d4fe !important; color: #084298 !important;">بنكي</span>
            @endif
        </div>
        
        <div class="coa-account-balance" style="font-weight: bold !important; text-align: left !important; direction: ltr !important; padding: 4px 10px !important; border-radius: 4px !important; background-color: #f8f9fa !important; border: 1px solid #e9ecef !important; white-space: nowrap !important;">
            @if(isset($account->balance_type))
                <span class="coa-balance-type {{ $account->balance_type }}" style="font-size: 0.75em !important; padding: 1px 4px !important; border-radius: 3px !important; margin-left: 5px !important; background-color: {{ $account->balance_type == 'debit' ? '#e9f5e9' : '#f8d7da' }} !important; color: {{ $account->balance_type == 'debit' ? '#28a745' : '#dc3545' }} !important;">
                    {{ $account->balance_type == 'debit' ? 'مدين' : 'دائن' }}
                </span>
            @endif
            {{ number_format($account->current_balance ?? 0, 2) }} {{ $account->currency ?? 'SAR' }}
        </div>
    </div>
    
    @if($account->children && $account->children->count() > 0)
        <ul style="list-style-type: none !important; padding: 0 !important; margin: 0 !important; position: relative !important; padding-right: 35px !important; margin-right: 5px !important; border-right: 1px solid #ccc !important;">
            @foreach($account->children as $child)
                @include('accounting.chart_of_accounts.partials.account_tree_item_modern', ['account' => $child, 'level' => $level + 1])
            @endforeach
        </ul>
    @endif
</li>