<li>
    @if($account->children && $account->children->count() > 0)
        <span class="toggle">-</span>
    @endif
    <div class="account-item {{ $account->account_type }} {{ $account->is_parent ? 'parent-account' : 'child-account' }}">
        <div>
            <span class="account-code">{{ $account->account_code }}</span>
            <a href="{{ route('chart-of-accounts.show', $account->id) }}" class="account-name">{{ $account->name }}</a>
            @if($account->name_en)
                <small class="text-muted">({{ $account->name_en }})</small>
            @endif
            <span class="account-type-label">
                @switch($account->account_type)
                    @case('asset')
                        أصول
                        @break
                    @case('liability')
                        خصوم
                        @break
                    @case('equity')
                        حقوق ملكية
                        @break
                    @case('revenue')
                        إيرادات
                        @break
                    @case('expense')
                        مصروفات
                        @break
                    @default
                        {{ $account->account_type }}
                @endswitch
            </span>
            @if(!$account->is_active)
                <span class="badge badge-danger">غير نشط</span>
            @endif
            @if($account->is_system)
                <span class="badge badge-info">حساب نظام</span>
            @endif
            @if($account->is_parent)
                <span class="badge badge-dark">حساب أب</span>
            @else
                <span class="badge badge-light">حساب فرعي</span>
            @endif
            @if($account->is_cash_account)
                <span class="badge badge-success">حساب نقدي</span>
            @endif
            @if($account->is_bank_account)
                <span class="badge badge-primary">حساب بنكي</span>
            @endif
        </div>
        <div class="account-balance">
            @if(isset($account->balance_type))
                <span class="balance-type {{ $account->balance_type }}">
                    {{ $account->balance_type == 'debit' ? 'مدين' : 'دائن' }}
                </span>
            @endif
            {{ number_format($account->current_balance ?? 0, 2) }} {{ $account->currency ?? 'SAR' }}
        </div>
    </div>
    
    @if($account->children && $account->children->count() > 0)
        <ul>
            @foreach($account->children as $child)
                @include('accounting.chart_of_accounts.partials.account_tree_item', ['account' => $child])
            @endforeach
        </ul>
    @endif
</li>