@extends('layouts.app')

@section('title', 'دليل الحسابات')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">دليل الحسابات</h3>
                    <div>
                        <a href="{{ route('chart-of-accounts.tree') }}" class="btn btn-info">
                            <i class="fas fa-sitemap"></i> عرض شجرة الحسابات
                        </a>
                        <a href="{{ route('chart-of-accounts.trial-balance') }}" class="btn btn-secondary">
                            <i class="fas fa-balance-scale"></i> ميزان المراجعة
                        </a>
                        @can('create_chart_of_accounts')
                        <a href="{{ route('chart-of-accounts.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> إضافة حساب جديد
                        </a>
                        @endcan
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>رمز الحساب</th>
                                    <th>اسم الحساب</th>
                                    <th>نوع الحساب</th>
                                    <th>الحساب الأب</th>
                                    <th>الرصيد الحالي</th>
                                    <th>نوع الرصيد</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($accounts as $account)
                                <tr>
                                    <td>{{ $account->account_code }}</td>
                                    <td>{{ $account->name }}</td>
                                    <td>
                                        @switch($account->account_type)
                                            @case('asset')
                                                أصول
                                                @break
                                            @case('liability')
                                                خصوم
                                                @break
                                            @case('equity')
                                                حقوق ملكية
                                                @break
                                            @case('revenue')
                                                إيرادات
                                                @break
                                            @case('expense')
                                                مصروفات
                                                @break
                                            @default
                                                {{ $account->account_type }}
                                        @endswitch
                                        @if($account->sub_type)
                                            <small class="text-muted d-block">{{ $account->sub_type }}</small>
                                        @endif
                                    </td>
                                    <td>{{ $account->parent ? $account->parent->name : '-' }}</td>
                                    <td class="text-left">{{ number_format($account->current_balance, 2) }} {{ $account->currency }}</td>
                                    <td>{{ $account->balance_type == 'debit' ? 'مدين' : 'دائن' }}</td>
                                    <td>
                                        @if($account->is_active)
                                            <span class="badge badge-success">نشط</span>
                                        @else
                                            <span class="badge badge-danger">غير نشط</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('chart-of-accounts.show', $account->id) }}" class="btn btn-sm btn-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            @can('edit_chart_of_accounts')
                                            <a href="{{ route('chart-of-accounts.edit', $account->id) }}" class="btn btn-sm btn-primary">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            @endcan
                                            @can('delete_chart_of_accounts')
                                            <form action="{{ route('chart-of-accounts.destroy', $account->id) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذا الحساب؟');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                            @endcan
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center">لا توجد حسابات مسجلة</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        {{ $accounts->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection