@extends('layouts.app')

@section('title', 'تعديل الحساب')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تعديل الحساب: {{ $account->name }}</h3>
                </div>
                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('chart-of-accounts.update', $account->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="account_code">رمز الحساب <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="account_code" name="account_code" value="{{ old('account_code', $account->account_code) }}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name">اسم الحساب <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="name" name="name" value="{{ old('name', $account->name) }}" required>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name_en">اسم الحساب (بالإنجليزية)</label>
                                    <input type="text" class="form-control" id="name_en" name="name_en" value="{{ old('name_en', $account->name_en) }}">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="parent_id">الحساب الأب</label>
                                    <select class="form-control" id="parent_id" name="parent_id">
                                        <option value="">-- بدون حساب أب --</option>
                                        @foreach($parentAccounts as $parentAccount)
                                            <option value="{{ $parentAccount->id }}" {{ old('parent_id', $account->parent_id) == $parentAccount->id ? 'selected' : '' }}>
                                                {{ $parentAccount->account_code }} - {{ $parentAccount->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="account_type">نوع الحساب <span class="text-danger">*</span></label>
                                    <select class="form-control" id="account_type" name="account_type" required>
                                        <option value="">-- اختر نوع الحساب --</option>
                                        @foreach($accountTypes as $key => $value)
                                            <option value="{{ $key }}" {{ old('account_type', $account->account_type) == $key ? 'selected' : '' }}>
                                                {{ $value }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="sub_type">النوع الفرعي</label>
                                    <input type="text" class="form-control" id="sub_type" name="sub_type" value="{{ old('sub_type', $account->sub_type) }}">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="currency">العملة <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="currency" name="currency" value="{{ old('currency', $account->currency) }}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="description">وصف الحساب</label>
                                    <textarea class="form-control" id="description" name="description" rows="3">{{ old('description', $account->description) }}</textarea>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="is_active" name="is_active" value="1" {{ old('is_active', $account->is_active) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="is_active">حساب نشط</label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="is_cash_account" name="is_cash_account" value="1" {{ old('is_cash_account', $account->is_cash_account) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="is_cash_account">حساب نقدي</label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="is_bank_account" name="is_bank_account" value="1" {{ old('is_bank_account', $account->is_bank_account) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="is_bank_account">حساب بنكي</label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group mt-4">
                            <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                            <a href="{{ route('chart-of-accounts.index') }}" class="btn btn-secondary">إلغاء</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection