@extends('layouts.app')

@section('title', 'إضافة حساب جديد')

@section('content')
@push('styles')
<style>
    .parent-required {
        display: none;
    }
    .parent-hint {
        display: none;
    }
</style>
@endpush
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إضافة حساب جديد</h3>
                </div>
                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('chart-of-accounts.store') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="account_code">رمز الحساب <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="account_code" name="account_code" value="{{ old('account_code') }}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name">اسم الحساب <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="name" name="name" value="{{ old('name') }}" required>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name_en">اسم الحساب (بالإنجليزية)</label>
                                    <input type="text" class="form-control" id="name_en" name="name_en" value="{{ old('name_en') }}">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="account_nature">طبيعة الحساب <span class="text-danger">*</span></label>
                                    <select class="form-control" id="account_nature" name="account_nature" required>
                                        <option value="">-- اختر طبيعة الحساب --</option>
                                        <option value="parent" {{ old('account_nature') == 'parent' ? 'selected' : '' }}>حساب رئيسي (أب)</option>
                                        <option value="child" {{ old('account_nature') == 'child' ? 'selected' : '' }}>حساب فرعي (نهائي)</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row" id="parent_account_row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="parent_id">الحساب الأب <span class="text-danger parent-required">*</span></label>
                                    <select class="form-control" id="parent_id" name="parent_id">
                                        <option value="">-- اختر الحساب الأب --</option>
                                        @foreach($parentAccounts as $parentAccount)
                                            <option value="{{ $parentAccount->id }}" {{ old('parent_id') == $parentAccount->id ? 'selected' : '' }}>
                                                {{ $parentAccount->account_code }} - {{ $parentAccount->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <small class="text-muted parent-hint">يجب اختيار حساب أب للحسابات الفرعية</small>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="account_type">نوع الحساب <span class="text-danger">*</span></label>
                                    <select class="form-control" id="account_type" name="account_type" required>
                                        <option value="">-- اختر نوع الحساب --</option>
                                        @foreach($accountTypes as $key => $value)
                                            <option value="{{ $key }}" {{ old('account_type') == $key ? 'selected' : '' }}>
                                                {{ $value }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="sub_type">النوع الفرعي</label>
                                    <input type="text" class="form-control" id="sub_type" name="sub_type" value="{{ old('sub_type') }}">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="opening_balance">الرصيد الافتتاحي <span class="text-danger">*</span></label>
                                    <input type="number" step="0.01" class="form-control" id="opening_balance" name="opening_balance" value="{{ old('opening_balance', '0.00') }}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="balance_type">نوع الرصيد <span class="text-danger">*</span></label>
                                    <select class="form-control" id="balance_type" name="balance_type" required>
                                        <option value="debit" {{ old('balance_type') == 'debit' ? 'selected' : '' }}>مدين</option>
                                        <option value="credit" {{ old('balance_type') == 'credit' ? 'selected' : '' }}>دائن</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="currency">العملة <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="currency" name="currency" value="{{ old('currency', 'SAR') }}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="description">وصف الحساب</label>
                                    <textarea class="form-control" id="description" name="description" rows="3">{{ old('description') }}</textarea>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="is_active" name="is_active" value="1" {{ old('is_active', '1') == '1' ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="is_active">حساب نشط</label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="is_cash_account" name="is_cash_account" value="1" {{ old('is_cash_account') == '1' ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="is_cash_account">حساب نقدي</label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="is_bank_account" name="is_bank_account" value="1" {{ old('is_bank_account') == '1' ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="is_bank_account">حساب بنكي</label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group mt-4">
                            <button type="submit" class="btn btn-primary">حفظ</button>
                            <a href="{{ route('chart-of-accounts.index') }}" class="btn btn-secondary">إلغاء</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // الحصول على عناصر النموذج
        const accountNatureSelect = document.getElementById('account_nature');
        const parentAccountRow = document.getElementById('parent_account_row');
        const parentIdSelect = document.getElementById('parent_id');
        const parentRequired = document.querySelector('.parent-required');
        const parentHint = document.querySelector('.parent-hint');
        
        // دالة لتحديث حالة حقل الحساب الأب بناءً على طبيعة الحساب
        function updateParentAccountField() {
            if (accountNatureSelect.value === 'child') {
                // إذا كان الحساب فرعي (نهائي)، اجعل حقل الحساب الأب إلزامي
                parentRequired.style.display = 'inline';
                parentHint.style.display = 'block';
                parentIdSelect.setAttribute('required', 'required');
                parentAccountRow.style.display = 'flex';
            } else if (accountNatureSelect.value === 'parent') {
                // إذا كان الحساب رئيسي (أب)، اجعل حقل الحساب الأب اختياري
                parentRequired.style.display = 'none';
                parentHint.style.display = 'none';
                parentIdSelect.removeAttribute('required');
                parentAccountRow.style.display = 'flex';
            } else {
                // إذا لم يتم اختيار طبيعة الحساب بعد
                parentAccountRow.style.display = 'none';
            }
        }
        
        // تنفيذ الدالة عند تحميل الصفحة
        updateParentAccountField();
        
        // إضافة مستمع حدث لتغيير طبيعة الحساب
        accountNatureSelect.addEventListener('change', updateParentAccountField);
        
        // التحقق من صحة النموذج قبل الإرسال
        document.querySelector('form').addEventListener('submit', function(event) {
            if (accountNatureSelect.value === 'child' && !parentIdSelect.value) {
                event.preventDefault();
                alert('يجب اختيار حساب أب للحسابات الفرعية');
                parentIdSelect.focus();
            }
        });
    });
</script>
@endpush