@extends('layouts.app')

@section('title', 'تفاصيل الفترة المحاسبية')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تفاصيل الفترة المحاسبية: {{ $period->name }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('accounting-periods.index') }}" class="btn btn-default btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">معلومات الفترة المحاسبية</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">الاسم</th>
                                            <td>{{ $period->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>السنة المالية</th>
                                            <td>
                                                <a href="{{ route('fiscal-years.show', $period->fiscalYear->id) }}">
                                                    {{ $period->fiscalYear->name }}
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ البداية</th>
                                            <td>{{ $period->start_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ النهاية</th>
                                            <td>{{ $period->end_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @if($period->is_closed)
                                                    <span class="badge badge-danger">مغلقة</span>
                                                @else
                                                    <span class="badge badge-success">مفتوحة</span>
                                                @endif
                                            </td>
                                        </tr>
                                    </table>
                                    
                                    <div class="mt-3">
                                        @if(!$period->is_closed)
                                            @can('edit_accounting_periods')
                                            <a href="{{ route('accounting-periods.edit', $period->id) }}" class="btn btn-warning btn-sm">
                                                <i class="fas fa-edit"></i> تعديل
                                            </a>
                                            @endcan
                                            
                                            @can('close_accounting_periods')
                                            <a href="{{ route('accounting-periods.close', $period->id) }}" 
                                               class="btn btn-danger btn-sm"
                                               onclick="return confirm('هل أنت متأكد من إغلاق هذه الفترة المحاسبية؟')">
                                                <i class="fas fa-lock"></i> إغلاق الفترة
                                            </a>
                                            @endcan
                                        @else
                                            @can('reopen_accounting_periods')
                                            <a href="{{ route('accounting-periods.reopen', $period->id) }}" 
                                               class="btn btn-success btn-sm"
                                               onclick="return confirm('هل أنت متأكد من إعادة فتح هذه الفترة المحاسبية؟')">
                                                <i class="fas fa-lock-open"></i> إعادة فتح الفترة
                                            </a>
                                            @endcan
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">إحصائيات الفترة</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="info-box bg-info">
                                                <span class="info-box-icon"><i class="fas fa-file-invoice"></i></span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">عدد القيود</span>
                                                    <span class="info-box-number">{{ $period->journalEntries->count() }}</span>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="info-box bg-success">
                                                <span class="info-box-icon"><i class="fas fa-calendar-day"></i></span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">عدد الأيام</span>
                                                    <span class="info-box-number">{{ $period->start_date->diffInDays($period->end_date) + 1 }}</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">آخر القيود المحاسبية في الفترة</h5>
                                    <div class="card-tools">
                                        @if(!$period->is_closed)
                                            @can('create_journal_entries')
                                            <a href="{{ route('journal-entries.create', ['period_id' => $period->id]) }}" class="btn btn-primary btn-sm">
                                                <i class="fas fa-plus"></i> إضافة قيد جديد
                                            </a>
                                            @endcan
                                        @endif
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>الرقم</th>
                                                    <th>التاريخ</th>
                                                    <th>الوصف</th>
                                                    <th>المبلغ</th>
                                                    <th>الحالة</th>
                                                    <th>الإجراءات</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($period->journalEntries as $entry)
                                                <tr>
                                                    <td>{{ $entry->entry_number }}</td>
                                                    <td>{{ $entry->entry_date->format('Y-m-d') }}</td>
                                                    <td>{{ Str::limit($entry->description, 50) }}</td>
                                                    <td>{{ number_format($entry->amount, 2) }}</td>
                                                    <td>
                                                        @if($entry->is_posted)
                                                            <span class="badge badge-success">مرحّل</span>
                                                        @else
                                                            <span class="badge badge-warning">غير مرحّل</span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        <div class="btn-group">
                                                            <a href="{{ route('journal-entries.show', $entry->id) }}" class="btn btn-info btn-sm">
                                                                <i class="fas fa-eye"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                @empty
                                                <tr>
                                                    <td colspan="6" class="text-center">لا توجد قيود محاسبية في هذه الفترة</td>
                                                </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                    
                                    @if($period->journalEntries->count() > 0)
                                    <div class="mt-3">
                                        <a href="{{ route('journal-entries.index', ['period_id' => $period->id]) }}" class="btn btn-default">
                                            عرض جميع القيود في هذه الفترة
                                        </a>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection