@extends('layouts.app')

@section('title', 'الفترات المحاسبية')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">الفترات المحاسبية</h3>
                    <div class="card-tools">
                        @can('create_accounting_periods')
                        <a href="{{ route('accounting-periods.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> إضافة فترة محاسبية جديدة
                        </a>
                        @endcan
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                    
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>الاسم</th>
                                    <th>السنة المالية</th>
                                    <th>تاريخ البداية</th>
                                    <th>تاريخ النهاية</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($periods as $period)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $period->name }}</td>
                                    <td>{{ $period->fiscalYear->name }}</td>
                                    <td>{{ $period->start_date->format('Y-m-d') }}</td>
                                    <td>{{ $period->end_date->format('Y-m-d') }}</td>
                                    <td>
                                        @if($period->is_closed)
                                            <span class="badge badge-danger">مغلقة</span>
                                        @else
                                            <span class="badge badge-success">مفتوحة</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('accounting-periods.show', $period->id) }}" class="btn btn-info btn-sm">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            
                                            @if(!$period->is_closed)
                                                @can('edit_accounting_periods')
                                                <a href="{{ route('accounting-periods.edit', $period->id) }}" class="btn btn-warning btn-sm">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                @endcan
                                                
                                                @can('close_accounting_periods')
                                                <a href="{{ route('accounting-periods.close', $period->id) }}" 
                                                   class="btn btn-danger btn-sm"
                                                   onclick="return confirm('هل أنت متأكد من إغلاق هذه الفترة المحاسبية؟')">
                                                    <i class="fas fa-lock"></i>
                                                </a>
                                                @endcan
                                            @else
                                                @can('reopen_accounting_periods')
                                                <a href="{{ route('accounting-periods.reopen', $period->id) }}" 
                                                   class="btn btn-success btn-sm"
                                                   onclick="return confirm('هل أنت متأكد من إعادة فتح هذه الفترة المحاسبية؟')">
                                                    <i class="fas fa-lock-open"></i>
                                                </a>
                                                @endcan
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center">لا توجد فترات محاسبية</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-3">
                        {{ $periods->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection