@extends('layouts.app')

@section('title', 'تعديل الفترة المحاسبية')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تعديل الفترة المحاسبية: {{ $period->name }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('accounting-periods.index') }}" class="btn btn-default btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                    
                    <form action="{{ route('accounting-periods.update', $period->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="form-group">
                            <label for="fiscal_year_id">السنة المالية</label>
                            <select name="fiscal_year_id" id="fiscal_year_id" class="form-control @error('fiscal_year_id') is-invalid @enderror" required>
                                <option value="">-- اختر السنة المالية --</option>
                                @foreach($fiscalYears as $fiscalYear)
                                    <option value="{{ $fiscalYear->id }}" data-start="{{ $fiscalYear->start_date->format('Y-m-d') }}" data-end="{{ $fiscalYear->end_date->format('Y-m-d') }}" {{ (old('fiscal_year_id', $period->fiscal_year_id) == $fiscalYear->id) ? 'selected' : '' }}>
                                        {{ $fiscalYear->name }} ({{ $fiscalYear->start_date->format('Y-m-d') }} - {{ $fiscalYear->end_date->format('Y-m-d') }})
                                    </option>
                                @endforeach
                            </select>
                            @error('fiscal_year_id')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="name">اسم الفترة المحاسبية</label>
                            <input type="text" name="name" id="name" class="form-control @error('name') is-invalid @enderror" value="{{ old('name', $period->name) }}" required>
                            @error('name')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="start_date">تاريخ البداية</label>
                                    <input type="date" name="start_date" id="start_date" class="form-control @error('start_date') is-invalid @enderror" value="{{ old('start_date', $period->start_date->format('Y-m-d')) }}" required>
                                    @error('start_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="end_date">تاريخ النهاية</label>
                                    <input type="date" name="end_date" id="end_date" class="form-control @error('end_date') is-invalid @enderror" value="{{ old('end_date', $period->end_date->format('Y-m-d')) }}" required>
                                    @error('end_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="alert alert-info fiscal-year-dates">
                            <strong>ملاحظة:</strong> يجب أن تكون الفترة المحاسبية ضمن نطاق السنة المالية (<span class="fiscal-start"></span> - <span class="fiscal-end"></span>)
                        </div>
                        
                        <div class="form-group mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> حفظ التغييرات
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // عرض نطاق السنة المالية عند اختيارها
        $('#fiscal_year_id').change(function() {
            var selected = $(this).find('option:selected');
            if (selected.val()) {
                var startDate = selected.data('start');
                var endDate = selected.data('end');
                
                $('.fiscal-start').text(startDate);
                $('.fiscal-end').text(endDate);
                $('.fiscal-year-dates').removeClass('d-none');
                
                // تعيين الحد الأدنى والأقصى لتواريخ الفترة المحاسبية
                $('#start_date').attr('min', startDate);
                $('#start_date').attr('max', endDate);
                $('#end_date').attr('min', startDate);
                $('#end_date').attr('max', endDate);
            } else {
                $('.fiscal-year-dates').addClass('d-none');
            }
        });
        
        // تشغيل الحدث عند تحميل الصفحة
        $('#fiscal_year_id').trigger('change');
    });
</script>
@endsection