<?php

/**
 * هذا السكريبت يقوم بإعادة إنشاء كشوفات حساب العملاء لجميع القيود المحاسبية
 * باستخدام الدالة المحسنة التي تعتمد على معرف العميل (ID)
 */

require_once __DIR__ . '/vendor/autoload.php';

use Illuminate\Support\Facades\Log;

// تهيئة Laravel
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

echo "بدء إعادة إنشاء كشوفات حساب العملاء لجميع القيود المحاسبية...\n";

// الحصول على جميع القيود المحاسبية المرحلة
$entries = \App\Models\JournalEntry::where('is_posted', true)->get();

echo "تم العثور على " . $entries->count() . " قيد محاسبي مرحل.\n";

$created = 0;
$skipped = 0;

foreach ($entries as $entry) {
    echo "معالجة القيد المحاسبي رقم: " . $entry->id . " - رقم القيد: " . $entry->entry_number . "... ";
    
    // حذف أي سجلات موجودة لهذا القيد المحاسبي
    \App\Models\CustomerStatement::where('reference_type', 'App\Models\JournalEntry')
        ->where('reference_id', $entry->id)
        ->delete();
    
    // إنشاء كشف حساب جديد
    $result = \App\Models\CustomerStatement::createForJournalEntry($entry);
    
    if ($result) {
        echo "تم بنجاح\n";
        $created++;
    } else {
        echo "تم تخطيه\n";
        $skipped++;
    }
}

echo "\nاكتملت العملية!\n";
echo "تم إنشاء كشوفات حساب لـ " . $created . " قيد محاسبي.\n";
echo "تم تخطي " . $skipped . " قيد محاسبي.\n";
