<?php

// Cargar la aplicación
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

echo "Regenerando todos los estados de cuenta de clientes...\n";

// Eliminar todos los registros existentes en customer_statements
\App\Models\CustomerStatement::truncate();
echo "Se han eliminado todos los registros existentes en customer_statements.\n";

// Obtener todos los asientos contables publicados
$entries = \App\Models\JournalEntry::where('is_posted', true)->get();
echo "Total de asientos contables publicados: " . $entries->count() . "\n";

$created = 0;
$skipped = 0;

foreach ($entries as $entry) {
    echo "Procesando asiento ID: " . $entry->id . " - Número: " . $entry->entry_number . "... ";
    
    $result = \App\Models\CustomerStatement::createForJournalEntry($entry);
    
    if ($result) {
        echo "OK\n";
        $created++;
    } else {
        echo "Omitido\n";
        $skipped++;
    }
}

echo "\nResumen:\n";
echo "Total de asientos procesados: " . $entries->count() . "\n";
echo "Estados de cuenta creados: " . $created . "\n";
echo "Asientos omitidos: " . $skipped . "\n";