// ملف JavaScript بسيط لتفعيل القوائم المنسدلة
document.addEventListener('DOMContentLoaded', function () {
    console.log('تم تحميل ملف simple-dropdown.js');

    // الحصول على جميع القوائم المنسدلة
    var dropdowns = document.querySelectorAll('.nav-item.dropdown');

    // إضافة مستمع حدث لكل قائمة منسدلة
    dropdowns.forEach(function (dropdown) {
        var toggle = dropdown.querySelector('.dropdown-toggle');
        var menu = dropdown.querySelector('.dropdown-menu');

        if (toggle && menu) {
            // عند النقر على زر القائمة المنسدلة
            toggle.addEventListener('click', function (e) {
                e.preventDefault();
                e.stopPropagation();

                // إغلاق جميع القوائم المنسدلة الأخرى
                document.querySelectorAll('.dropdown-menu').forEach(function (otherMenu) {
                    if (otherMenu !== menu && otherMenu.classList.contains('show')) {
                        otherMenu.classList.remove('show');
                    }
                });

                // تبديل حالة القائمة المنسدلة الحالية
                menu.classList.toggle('show');
            });
        }
    });

    // إغلاق القوائم المنسدلة عند النقر خارجها
    document.addEventListener('click', function (e) {
        if (!e.target.closest('.dropdown')) {
            document.querySelectorAll('.dropdown-menu.show').forEach(function (menu) {
                menu.classList.remove('show');
            });
        }
    });

    // تفعيل زر تسجيل الخروج
    var logoutButtons = document.querySelectorAll('.logout-btn');
    logoutButtons.forEach(function (button) {
        button.addEventListener('click', function (e) {
            e.preventDefault();
            document.getElementById('logout-form').submit();
        });
    });
});