// ملف للتأكد من أن قائمة رئيسية واحدة فقط مفتوحة في أي وقت
document.addEventListener('DOMContentLoaded', function () {
    console.log('تم تحميل ملف sidebar-single-menu.js');

    // الحصول على جميع القوائم الرئيسية التي تحتوي على قوائم فرعية
    const navItems = document.querySelectorAll('.nav-sidebar > .nav-item');
    const mainMenuItems = Array.from(navItems).filter(item => item.querySelector('.nav-treeview'));
    console.log('عدد القوائم الرئيسية:', mainMenuItems.length);

    // إضافة مستمعات أحداث للقوائم الرئيسية
    mainMenuItems.forEach((menu, index) => {
        // إضافة معرف للقائمة
        menu.setAttribute('data-menu-index', index);

        // الحصول على الرابط الرئيسي للقائمة
        const mainLink = menu.querySelector('.nav-link');

        // إضافة مستمع حدث للنقر على الرابط الرئيسي للقائمة
        if (mainLink) {
            mainLink.addEventListener('click', function (e) {
                // منع السلوك الافتراضي للرابط (منع الانتقال)
                e.preventDefault();

                // التحقق مما إذا كانت القائمة مفتوحة بالفعل
                const isOpen = menu.classList.contains('menu-open');

                // إذا كانت القائمة مغلقة، أغلق جميع القوائم الأخرى أولاً
                if (!isOpen) {
                    // إغلاق جميع القوائم الرئيسية الأخرى
                    mainMenuItems.forEach((otherMenu) => {
                        if (otherMenu !== menu && otherMenu.classList.contains('menu-open')) {
                            otherMenu.classList.remove('menu-open');
                            const otherLink = otherMenu.querySelector('.nav-link');
                            if (otherLink && !otherLink.getAttribute('href').includes(window.location.pathname)) {
                                otherLink.classList.remove('active');
                            }
                        }
                    });

                    // فتح القائمة الحالية
                    menu.classList.add('menu-open');
                    mainLink.classList.add('active');
                } else {
                    // إذا كانت القائمة مفتوحة بالفعل، أغلقها
                    menu.classList.remove('menu-open');

                    // إزالة الفئة النشطة من الرابط إذا لم يكن هو الصفحة الحالية
                    if (!mainLink.getAttribute('href').includes(window.location.pathname)) {
                        mainLink.classList.remove('active');
                    }
                }

                // حفظ حالة القوائم
                saveMenuStates();
            });
        }
    });

    // حفظ حالة القوائم
    function saveMenuStates() {
        const menuStates = {};
        mainMenuItems.forEach((menu, index) => {
            const isOpen = menu.classList.contains('menu-open');
            menuStates[`menu_${index}`] = isOpen;
        });
        localStorage.setItem('sidebarMenuStates', JSON.stringify(menuStates));
        console.log('تم حفظ حالات القوائم:', menuStates);
    }

    // استرجاع حالة القوائم عند تحميل الصفحة
    function restoreMenuStates() {
        const savedStates = localStorage.getItem('sidebarMenuStates');
        if (savedStates) {
            const menuStates = JSON.parse(savedStates);
            console.log('استرجاع حالات القوائم:', menuStates);

            // التأكد من أن قائمة واحدة فقط مفتوحة
            let openMenuFound = false;

            mainMenuItems.forEach((menu, index) => {
                const shouldBeOpen = menuStates[`menu_${index}`];

                // إذا كانت هذه القائمة يجب أن تكون مفتوحة وليس هناك قائمة أخرى مفتوحة بالفعل
                if (shouldBeOpen && !openMenuFound) {
                    menu.classList.add('menu-open');
                    const navLink = menu.querySelector('.nav-link');
                    if (navLink) {
                        navLink.classList.add('active');
                    }
                    openMenuFound = true;
                } else {
                    // إغلاق أي قوائم أخرى
                    menu.classList.remove('menu-open');
                    const navLink = menu.querySelector('.nav-link');
                    if (navLink && !navLink.getAttribute('href').includes(window.location.pathname)) {
                        navLink.classList.remove('active');
                    }
                }
            });
        }
    }

    // استرجاع حالة القوائم عند تحميل الصفحة
    restoreMenuStates();

    // إضافة مستمع حدث لزر تبديل القائمة الجانبية
    const sidebarToggleBtn = document.querySelector('[data-widget="pushmenu"]');
    if (sidebarToggleBtn) {
        console.log('تم العثور على زر تبديل القائمة الجانبية');

        sidebarToggleBtn.addEventListener('click', function () {
            console.log('تم النقر على زر تبديل القائمة الجانبية');

            // إعادة تعيين حالة القوائم بعد تأخير قصير
            setTimeout(function () {
                restoreMenuStates();
            }, 300);
        });
    }

    // حفظ حالة القوائم عند مغادرة الصفحة
    window.addEventListener('beforeunload', function () {
        saveMenuStates();
    });
});