// ملف للتأكد من أن قائمة رئيسية واحدة فقط مفتوحة في أي وقت
document.addEventListener('DOMContentLoaded', function () {
    console.log('تم تحميل ملف sidebar-single-menu-new.js');

    // تنفيذ الكود بعد تأخير أطول للتأكد من تحميل جميع العناصر وتنفيذ جميع الملفات الأخرى أولاً
    setTimeout(function () {
        console.log('بدء تنفيذ سلوك القائمة الواحدة');
        // إزالة مستمعات الأحداث من ملفات أخرى
        removeOtherEventListeners();
        // تهيئة سلوك القائمة الواحدة
        initSingleMenuBehavior();
        // تنفيذ فحص إضافي بعد تأخير إضافي
        setTimeout(function () {
            openActiveMenuOnly();
            console.log('تم تنفيذ فحص إضافي للقوائم المفتوحة');
        }, 500);
    }, 2000);

    // إزالة مستمعات الأحداث من ملفات أخرى
    function removeOtherEventListeners() {
        try {
            // إزالة مستمعات الأحداث من modern-dashboard.js
            const treeviewToggles = document.querySelectorAll('.nav-sidebar > .nav-item > .nav-link');
            treeviewToggles.forEach(function (toggle) {
                // إنشاء نسخة جديدة من العنصر لإزالة جميع مستمعات الأحداث
                const newToggle = toggle.cloneNode(true);
                if (toggle.parentNode) {
                    toggle.parentNode.replaceChild(newToggle, toggle);
                }
            });
            console.log('تم إزالة مستمعات الأحداث السابقة من القوائم الرئيسية');
        } catch (error) {
            console.error('حدث خطأ أثناء إزالة مستمعات الأحداث:', error);
        }
    }

    function initSingleMenuBehavior() {
        try {
            // الحصول على جميع روابط القوائم الرئيسية
            const mainMenuLinks = document.querySelectorAll('.nav-sidebar > .nav-item > a.nav-link');
            console.log('عدد روابط القوائم الرئيسية:', mainMenuLinks.length);

            if (mainMenuLinks.length === 0) {
                console.warn('لم يتم العثور على روابط القوائم الرئيسية!');
                return;
            }

            // إضافة مستمعات أحداث لروابط القوائم الرئيسية
            mainMenuLinks.forEach(link => {
                // إضافة الفئة main-active لجميع روابط القوائم الرئيسية لتطبيق الخلفية الزرقاء
                link.classList.add('main-active');
                link.classList.add('active');

                // إنشاء نسخة جديدة من الرابط لإزالة جميع مستمعات الأحداث السابقة
                const newLink = link.cloneNode(true);
                if (link.parentNode) {
                    link.parentNode.replaceChild(newLink, link);
                    // إضافة مستمع حدث جديد للنسخة الجديدة
                    newLink.addEventListener('click', handleMainMenuClick);
                    // إضافة الفئات للنسخة الجديدة أيضًا
                    newLink.classList.add('main-active');
                    newLink.classList.add('active');
                }
            });

            // فتح القائمة النشطة فقط (إذا وجدت)
            openActiveMenuOnly();

            console.log('تم تهيئة سلوك القائمة الواحدة بنجاح');
        } catch (error) {
            console.error('حدث خطأ أثناء تهيئة سلوك القائمة الواحدة:', error);
        }
    }

    // التعامل مع النقر على رابط القائمة الرئيسية
    function handleMainMenuClick(e) {
        try {
            // الحصول على عنصر القائمة الرئيسي
            const menuItem = this.parentElement;
            if (!menuItem) {
                console.warn('لم يتم العثور على عنصر القائمة الرئيسي!');
                return;
            }

            // التحقق مما إذا كانت هذه قائمة رئيسية تحتوي على قائمة فرعية
            if (!menuItem.querySelector('.nav-treeview')) {
                console.log('ليست قائمة رئيسية بها قوائم فرعية، اترك السلوك الافتراضي');
                return; // ليست قائمة رئيسية بها قوائم فرعية، اترك السلوك الافتراضي
            }

            // منع السلوك الافتراضي للرابط
            e.preventDefault();
            e.stopPropagation(); // منع انتشار الحدث

            // التحقق مما إذا كانت القائمة مفتوحة بالفعل
            const isOpen = menuItem.classList.contains('menu-open');
            console.log('حالة القائمة:', isOpen ? 'مفتوحة' : 'مغلقة');

            // إضافة الفئة active للرابط الحالي دائمًا
            this.classList.add('active');
            this.classList.add('main-active');

            // تبديل حالة القائمة الحالية (فتح/إغلاق)
            if (isOpen) {
                // إغلاق القائمة الحالية إذا كانت مفتوحة
                menuItem.classList.remove('menu-open');
                console.log('تم إغلاق القائمة:', this.textContent.trim());
            } else {
                // فتح القائمة الحالية إذا كانت مغلقة
                menuItem.classList.add('menu-open');
                console.log('تم فتح القائمة:', this.textContent.trim());

                // إغلاق القوائم الأخرى عند فتح قائمة جديدة
                const otherOpenMenus = document.querySelectorAll('.nav-sidebar > .nav-item.menu-open');
                otherOpenMenus.forEach(menu => {
                    if (menu !== menuItem) {
                        menu.classList.remove('menu-open');
                    }
                });
            }

            // تنفيذ الإجراء بعد تأخير قصير للتأكد من تطبيق التغييرات
            setTimeout(function () {
                try {
                    // تأكد من أن الرابط الحالي لا يزال يحتوي على الفئة active
                    if (this && this.classList) {
                        this.classList.add('active');
                    }
                } catch (innerError) {
                    console.error('حدث خطأ أثناء التحقق من القوائم المفتوحة:', innerError);
                }
            }, 200);
        } catch (error) {
            console.error('حدث خطأ أثناء معالجة النقر على القائمة:', error);
        }
    }

    // إغلاق جميع القوائم الرئيسية ما عدا القائمة النشطة
    function closeAllMainMenus() {
        try {
            // الحصول على جميع القوائم الرئيسية المفتوحة
            const openMenus = document.querySelectorAll('.nav-sidebar > .nav-item.menu-open');
            console.log('عدد القوائم المفتوحة:', openMenus.length);

            if (openMenus.length <= 1) {
                // إذا كان هناك قائمة واحدة فقط مفتوحة أو لا توجد قوائم مفتوحة، لا تفعل شيئًا
                return;
            }

            // البحث عن القائمة التي تحتوي على رابط نشط
            let activeMenu = null;
            for (let i = 0; i < openMenus.length; i++) {
                if (openMenus[i].querySelector('.nav-treeview .nav-link.active')) {
                    activeMenu = openMenus[i];
                    break;
                }
            }

            // إذا لم يتم العثور على قائمة نشطة، استخدم القائمة الأولى
            if (!activeMenu && openMenus.length > 0) {
                activeMenu = openMenus[0];
            }

            // إغلاق جميع القوائم ما عدا القائمة النشطة
            openMenus.forEach(menu => {
                try {
                    if (menu !== activeMenu) {
                        menu.classList.remove('menu-open');
                        // تأكد من أن جميع الروابط الرئيسية تحتفظ بالفئات active و main-active
                        const link = menu.querySelector(':scope > .nav-link');
                        if (link) {
                            link.classList.add('active');
                            link.classList.add('main-active');
                        }
                    } else {
                        // تأكد من أن الرابط الرئيسي للقائمة النشطة يحتوي على الفئة active
                        const mainLink = menu.querySelector(':scope > .nav-link');
                        if (mainLink) {
                            mainLink.classList.add('active');
                            mainLink.classList.add('main-active');
                        }
                    }
                } catch (menuError) {
                    console.error('حدث خطأ أثناء إغلاق قائمة فردية:', menuError);
                }
            });

            // تأكد من أن جميع الروابط الرئيسية تحتوي على الفئات المطلوبة
            const allMainLinks = document.querySelectorAll('.nav-sidebar > .nav-item > .nav-link');
            allMainLinks.forEach(link => {
                link.classList.add('active');
                link.classList.add('main-active');
            });
        } catch (error) {
            console.error('حدث خطأ أثناء إغلاق جميع القوائم:', error);
        }
    }

    // فتح القائمة النشطة فقط (التي تحتوي على العنصر النشط)
    function openActiveMenuOnly() {
        try {
            // تطبيق الفئات active و main-active على جميع روابط القوائم الرئيسية أولاً
            const allMainLinks = document.querySelectorAll('.nav-sidebar > .nav-item > .nav-link');
            allMainLinks.forEach(link => {
                link.classList.add('active');
                link.classList.add('main-active');
            });

            // البحث عن رابط نشط في القوائم الفرعية
            const activeSubLink = document.querySelector('.nav-treeview .nav-link.active');
            console.log('البحث عن رابط نشط في القوائم الفرعية:', activeSubLink ? 'تم العثور عليه' : 'لم يتم العثور عليه');

            if (activeSubLink) {
                try {
                    // الحصول على القائمة الرئيسية التي تحتوي على الرابط النشط
                    const activeMainMenu = activeSubLink.closest('.nav-sidebar > .nav-item');

                    if (activeMainMenu) {
                        // فتح القائمة الرئيسية النشطة
                        activeMainMenu.classList.add('menu-open');
                        const mainLink = activeMainMenu.querySelector(':scope > .nav-link');
                        if (mainLink) {
                            mainLink.classList.add('active');
                            mainLink.classList.add('main-active');
                        }
                        console.log('تم فتح القائمة النشطة:', mainLink ? mainLink.textContent.trim() : 'غير معروف');
                    } else {
                        console.warn('لم يتم العثور على القائمة الرئيسية للرابط النشط!');
                    }
                } catch (subLinkError) {
                    console.error('حدث خطأ أثناء فتح القائمة النشطة (رابط فرعي):', subLinkError);
                }
            } else {
                try {
                    // إذا لم يكن هناك رابط نشط في القوائم الفرعية، ابحث عن رابط نشط في القوائم الرئيسية
                    const activeMainLink = document.querySelector('.nav-sidebar > .nav-item > .nav-link.active');
                    console.log('البحث عن رابط نشط في القوائم الرئيسية:', activeMainLink ? 'تم العثور عليه' : 'لم يتم العثور عليه');

                    if (activeMainLink) {
                        const activeMainMenu = activeMainLink.parentElement;
                        if (activeMainMenu && activeMainMenu.querySelector('.nav-treeview')) {
                            // فتح القائمة الرئيسية النشطة
                            activeMainMenu.classList.add('menu-open');
                            activeMainLink.classList.add('main-active');
                            console.log('تم فتح القائمة الرئيسية النشطة:', activeMainLink.textContent.trim());
                        }
                    }
                } catch (mainLinkError) {
                    console.error('حدث خطأ أثناء فتح القائمة النشطة (رابط رئيسي):', mainLinkError);
                }
            }

            // تأكد من أن جميع الروابط الرئيسية تحتوي على الفئات المطلوبة
            setTimeout(function () {
                try {
                    // تأكد من أن جميع الروابط الرئيسية تحتوي على الفئات active و main-active
                    const allMainLinks = document.querySelectorAll('.nav-sidebar > .nav-item > .nav-link');
                    allMainLinks.forEach(link => {
                        link.classList.add('active');
                        link.classList.add('main-active');
                    });

                    // تأكد من أن الروابط الرئيسية للقوائم المفتوحة تحتوي على الفئة active
                    const openMenus = document.querySelectorAll('.nav-sidebar > .nav-item.menu-open');
                    openMenus.forEach(menu => {
                        const menuLink = menu.querySelector(':scope > .nav-link');
                        if (menuLink) {
                            menuLink.classList.add('active');
                            menuLink.classList.add('main-active');
                        }
                    });
                } catch (checkError) {
                    console.error('حدث خطأ أثناء التحقق من القوائم المفتوحة:', checkError);
                }
            }, 300);
        } catch (error) {
            console.error('حدث خطأ أثناء فتح القائمة النشطة:', error);
        }
    }

    // التحقق مما إذا كان الرابط يشير إلى الصفحة الحالية
    function isCurrentPage(link) {
        if (!link || !link.getAttribute('href')) return false;

        const href = link.getAttribute('href');
        const currentPath = window.location.pathname;

        return currentPath.includes(href) && href !== '#';
    }

    // إعادة تهيئة السلوك عند تغيير حجم النافذة
    window.addEventListener('resize', function () {
        initSingleMenuBehavior();
    });

    // إضافة مستمع حدث لزر تبديل القائمة الجانبية
    const sidebarToggleBtn = document.querySelector('[data-widget="pushmenu"]');
    if (sidebarToggleBtn) {
        sidebarToggleBtn.addEventListener('click', function () {
            // إعادة تهيئة السلوك بعد تأخير قصير
            setTimeout(function () {
                initSingleMenuBehavior();
            }, 300);
        });
    }

    // إضافة مستمع حدث للنقر على أي مكان في الصفحة
    document.addEventListener('click', function (e) {
        // تأخير قصير للتأكد من تنفيذ أي أحداث أخرى أولاً
        setTimeout(function () {
            // التحقق من عدد القوائم المفتوحة
            const openMenus = document.querySelectorAll('.nav-sidebar > .nav-item.menu-open');
            if (openMenus.length > 1) {
                console.log('تم اكتشاف أكثر من قائمة مفتوحة بعد النقر، جاري الإصلاح...');
                openActiveMenuOnly();
            }
        }, 300);
    });

    // تنفيذ الإجراء مرة أخرى بعد تحميل الصفحة بالكامل
    window.addEventListener('load', function () {
        setTimeout(function () {
            initSingleMenuBehavior();
        }, 1500);
    });

    // تنفيذ الإجراء بشكل دوري للتأكد من أن قائمة واحدة فقط مفتوحة
    setInterval(function () {
        try {
            const openMenus = document.querySelectorAll('.nav-sidebar > .nav-item.menu-open');
            if (openMenus.length > 1) {
                console.log('تم اكتشاف أكثر من قائمة مفتوحة في الفحص الدوري، جاري الإصلاح...');
                openActiveMenuOnly();
            }

            // تأكد من أن جميع الروابط الرئيسية النشطة تحتوي على الفئة active
            const mainActiveLinks = document.querySelectorAll('.nav-sidebar > .nav-item > .nav-link.main-active');
            mainActiveLinks.forEach(link => {
                if (!link.classList.contains('active')) {
                    link.classList.add('active');
                    console.log('تم إعادة تنشيط الرابط الرئيسي:', link.textContent.trim());
                }
            });

            // تأكد من أن الروابط الرئيسية للقوائم المفتوحة تحتوي على الفئة active
            openMenus.forEach(menu => {
                const menuLink = menu.querySelector(':scope > .nav-link');
                if (menuLink && !menuLink.classList.contains('active')) {
                    menuLink.classList.add('active');
                    menuLink.classList.add('main-active');
                    console.log('تم إعادة تنشيط رابط القائمة المفتوحة:', menuLink.textContent.trim());
                }
            });
        } catch (error) {
            console.error('حدث خطأ أثناء الفحص الدوري للقوائم:', error);
        }
    }, 2000);
});