// إصلاح مشكلة القائمة الجانبية
document.addEventListener('DOMContentLoaded', function () {
    console.log('تم تحميل ملف sidebar-fix.js');

    // الحصول على جميع القوائم الرئيسية التي تحتوي على قوائم فرعية
    // استخدام طريقة بديلة لـ :has() لأنها غير مدعومة في بعض المتصفحات
    const navItems = document.querySelectorAll('.nav-sidebar > .nav-item');
    const mainMenuItems = Array.from(navItems).filter(item => item.querySelector('.nav-treeview'));
    console.log('عدد القوائم الرئيسية:', mainMenuItems.length);

    // حفظ حالة القوائم عند تحميل الصفحة
    function saveMenuStates() {
        const menuStates = {};
        mainMenuItems.forEach((menu, index) => {
            const isOpen = menu.classList.contains('menu-open');
            menuStates[`menu_${index}`] = isOpen;
        });
        localStorage.setItem('sidebarMenuStates', JSON.stringify(menuStates));
        console.log('تم حفظ حالات القوائم:', menuStates);
    }

    // استرجاع حالة القوائم
    function restoreMenuStates() {
        const savedStates = localStorage.getItem('sidebarMenuStates');
        if (savedStates) {
            const menuStates = JSON.parse(savedStates);
            console.log('استرجاع حالات القوائم:', menuStates);

            mainMenuItems.forEach((menu, index) => {
                const shouldBeOpen = menuStates[`menu_${index}`];
                if (shouldBeOpen) {
                    menu.classList.add('menu-open');
                    const navLink = menu.querySelector('.nav-link');
                    if (navLink) {
                        navLink.classList.add('active');
                    }
                }
            });
        }
    }

    // إضافة مستمعات أحداث للقوائم
    mainMenuItems.forEach((menu, index) => {
        // إضافة معرف للقائمة
        menu.setAttribute('data-menu-index', index);

        // إضافة مستمع حدث للنقر على القائمة
        menu.addEventListener('click', function (e) {
            if (e.target.tagName === 'A' || e.target.closest('a')) {
                // إذا تم النقر على الرابط الرئيسي للقائمة
                const clickedLink = e.target.classList.contains('nav-link') ? e.target : e.target.closest('.nav-link');
                if (clickedLink && clickedLink.parentElement === this) {
                    console.log('تم النقر على رابط القائمة:', index);

                    // تأخير قصير للسماح للقائمة بالتبديل قبل حفظ الحالة
                    setTimeout(() => {
                        saveMenuStates();
                    }, 50);
                }
            }
        });
    });

    // استرجاع حالة القوائم عند تحميل الصفحة
    restoreMenuStates();

    // إضافة مستمع حدث لزر تبديل القائمة الجانبية
    const sidebarToggleBtn = document.querySelector('[data-widget="pushmenu"]');
    if (sidebarToggleBtn) {
        console.log('تم العثور على زر تبديل القائمة الجانبية');

        sidebarToggleBtn.addEventListener('click', function () {
            console.log('تم النقر على زر تبديل القائمة الجانبية');

            // إعادة تعيين حالة القوائم بعد تأخير قصير
            setTimeout(function () {
                restoreMenuStates();
            }, 300);
        });
    } else {
        console.error('لم يتم العثور على زر تبديل القائمة الجانبية!');
    }

    // حفظ حالة القوائم عند مغادرة الصفحة
    window.addEventListener('beforeunload', function () {
        saveMenuStates();
    });
});