// إصلاح مشكلة الإزاحة في المحتوى
document.addEventListener('DOMContentLoaded', function () {
    // الحصول على عنصر content-wrapper
    var contentWrapper = document.querySelector('.content-wrapper');

    if (contentWrapper) {
        // إزالة جميع الخصائص المضمنة (inline styles) التي قد تسبب الإزاحة
        contentWrapper.setAttribute('style', '');

        // إضافة الخصائص الصحيحة
        if (document.body.classList.contains('sidebar-collapsed')) {
            contentWrapper.style.cssText = `
                width: calc(100% - 70px) !important;
                max-width: calc(100% - 70px) !important;
                margin-right: 70px !important;
                margin-left: 0 !important;
                right: 0 !important;
                left: auto !important;
                position: relative !important;
                overflow-x: hidden !important;
            `;
        } else {
            contentWrapper.style.cssText = `
                width: calc(100% - 220px) !important;
                max-width: calc(100% - 220px) !important;
                margin-right: 220px !important;
                margin-left: 0 !important;
                right: 0 !important;
                left: auto !important;
                position: relative !important;
                overflow-x: hidden !important;
            `;
        }

        console.log('تم إصلاح مشكلة الإزاحة في المحتوى');

        // إضافة مستمع لتغيير حالة الشريط الجانبي
        document.querySelector('[data-widget="pushmenu"]').addEventListener('click', function () {
            setTimeout(function () {
                if (document.body.classList.contains('sidebar-collapsed')) {
                    contentWrapper.style.cssText = `
                        width: calc(100% - 70px) !important;
                        max-width: calc(100% - 70px) !important;
                        margin-right: 70px !important;
                        margin-left: 0 !important;
                        right: 0 !important;
                        left: auto !important;
                        position: relative !important;
                        overflow-x: hidden !important;
                    `;
                } else {
                    contentWrapper.style.cssText = `
                        width: calc(100% - 220px) !important;
                        max-width: calc(100% - 220px) !important;
                        margin-right: 220px !important;
                        margin-left: 0 !important;
                        right: 0 !important;
                        left: auto !important;
                        position: relative !important;
                        overflow-x: hidden !important;
                    `;
                }
            }, 300); // انتظار انتهاء التحول
        });
    }
});