/**
 * Modern Dashboard JavaScript - Elevators ERP
 */

document.addEventListener('DOMContentLoaded', function () {
    // إصلاح مشكلة المساحة الفارغة على اليسار - تطبيق أنماط مباشرة
    function applyFullWidthStyles() {
        // تطبيق الأنماط على content-wrapper
        const contentWrapperDivs = document.querySelectorAll('.content-wrapper');
        contentWrapperDivs.forEach(div => {
            div.style.width = 'calc(100% - 220px)';
            div.style.marginRight = '220px';
            div.style.marginLeft = '0';
            div.style.paddingLeft = '10px';
            div.style.paddingRight = '10px';
            div.style.left = '0';
            div.style.right = '220px';
            div.style.position = 'relative';

            // إزالة أي أنماط مضمنة قد تسبب المشكلة
            div.style.removeProperty('margin-left');
            if (div.hasAttribute('style') && div.getAttribute('style').includes('margin-left')) {
                let style = div.getAttribute('style');
                style = style.replace(/margin-left:[^;]+;?/g, '');
                div.setAttribute('style', style);
            }
        });

        // تطبيق الأنماط على content
        const contentDivs = document.querySelectorAll('.content');
        contentDivs.forEach(div => {
            div.style.width = '100%';
            div.style.maxWidth = '100%';
            div.style.paddingLeft = '0';
            div.style.paddingRight = '0';
        });

        // تطبيق الأنماط على container-fluid
        const containerFluidDivs = document.querySelectorAll('.container-fluid');
        containerFluidDivs.forEach(div => {
            div.style.width = '100%';
            div.style.maxWidth = '100%';
            div.style.paddingLeft = '0';
            div.style.paddingRight = '0';
            div.style.marginLeft = '0';
            div.style.marginRight = '0';
        });

        // تطبيق الأنماط على الصفوف
        const rowDivs = document.querySelectorAll('.row');
        rowDivs.forEach(div => {
            div.style.width = '100%';
            div.style.maxWidth = '100%';
            div.style.marginLeft = '0';
            div.style.marginRight = '0';
        });

        // تطبيق الأنماط على البطاقات
        const cardDivs = document.querySelectorAll('.card');
        cardDivs.forEach(div => {
            div.style.width = '100%';
            div.style.maxWidth = '100%';
            div.style.marginLeft = '0';
            div.style.marginRight = '0';
        });
    }

    // تطبيق الأنماط عند تحميل الصفحة
    applyFullWidthStyles();

    // تطبيق الأنماط بعد 500 مللي ثانية للتأكد من تحميل جميع العناصر
    setTimeout(applyFullWidthStyles, 500);

    // تطبيق الأنماط عند تغيير حجم النافذة
    window.addEventListener('resize', applyFullWidthStyles);

    // Toggle Sidebar
    const sidebarToggleBtn = document.querySelector('[data-widget="pushmenu"]');
    const body = document.querySelector('body');

    // تطبيق الأنماط عند طي الشريط الجانبي
    if (sidebarToggleBtn) {
        // إضافة مستمع إضافي لتطبيق الأنماط عند طي الشريط الجانبي
        const updateContentStyles = function () {
            setTimeout(function () {
                const contentWrapperDivs = document.querySelectorAll('.content-wrapper');

                if (body.classList.contains('sidebar-collapsed')) {
                    // عند طي الشريط الجانبي
                    contentWrapperDivs.forEach(div => {
                        div.style.width = 'calc(100% - 70px)';
                        div.style.marginRight = '70px';
                        div.style.right = '70px';
                    });
                } else {
                    // عند فتح الشريط الجانبي
                    contentWrapperDivs.forEach(div => {
                        div.style.width = 'calc(100% - 220px)';
                        div.style.marginRight = '220px';
                        div.style.right = '220px';
                    });
                }
            }, 300); // انتظار انتهاء التأثير الحركي للشريط الجانبي
        };

        if (sidebarToggleBtn) {
            sidebarToggleBtn.addEventListener('click', function (e) {
                e.preventDefault();
                body.classList.toggle('sidebar-collapsed');

                // Save state to localStorage
                if (body.classList.contains('sidebar-collapsed')) {
                    localStorage.setItem('sidebar-state', 'collapsed');
                } else {
                    localStorage.setItem('sidebar-state', 'expanded');
                }

                // تطبيق الأنماط عند طي/فتح الشريط الجانبي
                updateContentStyles();
            });
        }

        // Restore sidebar state from localStorage
        const sidebarState = localStorage.getItem('sidebar-state');
        if (sidebarState === 'collapsed') {
            body.classList.add('sidebar-collapsed');
            // تطبيق الأنماط المناسبة عند استعادة حالة الشريط الجانبي
            setTimeout(updateContentStyles, 100);
        }

        // Mobile Sidebar Toggle
        const mobileToggleBtn = document.querySelector('.navbar-toggler');

        if (mobileToggleBtn) {
            mobileToggleBtn.addEventListener('click', function () {
                body.classList.toggle('sidebar-open');
            });
        }

        // Close sidebar when clicking outside on mobile
        document.addEventListener('click', function (e) {
            if (window.innerWidth < 992 &&
                body.classList.contains('sidebar-open') &&
                !e.target.closest('.main-sidebar') &&
                !e.target.closest('.navbar-toggler')) {
                body.classList.remove('sidebar-open');
            }
        });

        // Toggle Dark Mode
        const darkModeToggle = document.getElementById('dark-mode-toggle');

        if (darkModeToggle) {
            darkModeToggle.addEventListener('click', function () {
                body.classList.toggle('dark-mode');

                // Save state to localStorage
                if (body.classList.contains('dark-mode')) {
                    localStorage.setItem('dark-mode', 'enabled');
                    darkModeToggle.innerHTML = '<i class="fas fa-sun"></i>';
                } else {
                    localStorage.setItem('dark-mode', 'disabled');
                    darkModeToggle.innerHTML = '<i class="fas fa-moon"></i>';
                }
            });
        }

        // Restore dark mode state from localStorage
        const darkModeState = localStorage.getItem('dark-mode');
        if (darkModeState === 'enabled') {
            body.classList.add('dark-mode');
            if (darkModeToggle) {
                darkModeToggle.innerHTML = '<i class="fas fa-sun"></i>';
            }
        }

        // Dropdown Menu
        const dropdownToggles = document.querySelectorAll('.dropdown-toggle');

        dropdownToggles.forEach(function (toggle) {
            toggle.addEventListener('click', function (e) {
                e.preventDefault();
                const dropdownMenu = this.nextElementSibling;

                // Close all other dropdowns
                document.querySelectorAll('.dropdown-menu.show').forEach(function (menu) {
                    if (menu !== dropdownMenu) {
                        menu.classList.remove('show');
                    }
                });

                dropdownMenu.classList.toggle('show');
            });
        });

        // Close dropdowns when clicking outside
        document.addEventListener('click', function (e) {
            if (!e.target.closest('.dropdown')) {
                document.querySelectorAll('.dropdown-menu.show').forEach(function (menu) {
                    menu.classList.remove('show');
                });
            }
        });

        // Treeview Menu
        const treeviewMenus = document.querySelectorAll('.nav-treeview');
        const treeviewToggles = document.querySelectorAll('.nav-item.has-treeview > .nav-link');

        treeviewToggles.forEach(function (toggle) {
            toggle.addEventListener('click', function (e) {
                e.preventDefault();
                const parentItem = this.parentElement;

                if (body.classList.contains('sidebar-collapsed') && window.innerWidth > 992) {
                    return;
                }

                parentItem.classList.toggle('menu-open');
            });
        });

        // Initialize tooltips
        const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });

        // Initialize popovers
        const popoverTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="popover"]'));
        popoverTriggerList.map(function (popoverTriggerEl) {
            return new bootstrap.Popover(popoverTriggerEl);
        });

        // Add fade-in animation to cards
        const animatedElements = document.querySelectorAll('.fade-in');
        animatedElements.forEach(function (element) {
            element.style.opacity = '0';
        });

        // Trigger animations after a small delay
        setTimeout(function () {
            animatedElements.forEach(function (element) {
                element.style.opacity = '1';
            });
        }, 100);

        // Notification Counter Update
        function updateNotificationCount() {
            const notificationCountElement = document.getElementById('notification-count');
            const sidebarNotificationCountElement = document.getElementById('sidebar-notification-count');

            if (notificationCountElement || sidebarNotificationCountElement) {
                fetch('/notifications-unread-count')
                    .then(response => {
                        if (!response.ok) {
                            throw new Error('Network response was not ok');
                        }
                        return response.json();
                    })
                    .then(data => {
                        const count = data.count;

                        if (notificationCountElement) {
                            notificationCountElement.textContent = count;
                            notificationCountElement.style.display = count > 0 ? 'block' : 'none';
                        }

                        if (sidebarNotificationCountElement) {
                            sidebarNotificationCountElement.textContent = count;
                            sidebarNotificationCountElement.style.display = count > 0 ? 'inline-block' : 'none';
                        }
                    })
                    .catch(error => console.error('Error fetching notification count:', error));
            }
        }

        // Update notification count initially and every 60 seconds
        updateNotificationCount();
        setInterval(updateNotificationCount, 60000);

        // Responsive Tables
        const tables = document.querySelectorAll('table');
        tables.forEach(function (table) {
            if (!table.parentElement.classList.contains('table-responsive')) {
                const wrapper = document.createElement('div');
                wrapper.classList.add('table-responsive');
                table.parentNode.insertBefore(wrapper, table);
                wrapper.appendChild(table);
            }
        });

        // Back to top button
        const backToTopBtn = document.getElementById('back-to-top');

        if (backToTopBtn) {
            window.addEventListener('scroll', function () {
                if (window.pageYOffset > 300) {
                    backToTopBtn.classList.add('show');
                } else {
                    backToTopBtn.classList.remove('show');
                }
            });

            backToTopBtn.addEventListener('click', function (e) {
                e.preventDefault();
                window.scrollTo({ top: 0, behavior: 'smooth' });
            });
        }
    }
});