document.addEventListener('DOMContentLoaded', function () {
    console.log('تم تحميل ملف dropdown-fix.js');

    // طريقة مباشرة لتفعيل القوائم المنسدلة
    // التحقق من وجود jQuery قبل استخدامه
    if (typeof jQuery !== 'undefined') {
        $(document).ready(function () {
            console.log('jQuery جاهز');

            // تفعيل قائمة المستخدم بشكل خاص
            $('#navbarDropdown').on('click', function (e) {
                console.log('تم النقر على قائمة المستخدم');
                e.preventDefault();
                e.stopPropagation();

                // عرض القائمة المنسدلة
                var dropdownMenu = $(this).siblings('.dropdown-menu');
                dropdownMenu.toggleClass('show');

                // طباعة معلومات تصحيح
                console.log('عناصر القائمة المنسدلة:', dropdownMenu.find('a').length);
                dropdownMenu.find('a').each(function () {
                    console.log('عنصر قائمة:', $(this).text().trim());
                });
            });

            // تفعيل زر تسجيل الخروج بشكل خاص
            $('.dropdown-menu a[href*="logout"]').on('click', function (e) {
                console.log('تم النقر على زر تسجيل الخروج');
                e.preventDefault();
                $('#logout-form').submit();
            });

            // إغلاق القائمة عند النقر خارجها
            $(document).on('click', function (e) {
                if (!$(e.target).closest('.dropdown').length) {
                    $('.dropdown-menu').removeClass('show');
                }
            });

            // تفعيل جميع القوائم المنسدلة الأخرى
            $('.dropdown-toggle').not('#navbarDropdown').on('click', function (e) {
                e.preventDefault();
                e.stopPropagation();
                $(this).siblings('.dropdown-menu').toggleClass('show');
            });

            console.log('تم تفعيل جميع القوائم المنسدلة');
        });
    } else {
        console.warn('jQuery غير متوفر، سيتم استخدام JavaScript الأصلي');

        // استخدام JavaScript الأصلي بدلاً من jQuery
        const dropdownToggles = document.querySelectorAll('.dropdown-toggle');
        dropdownToggles.forEach(toggle => {
            toggle.addEventListener('click', function (e) {
                e.preventDefault();
                e.stopPropagation();
                const menu = this.nextElementSibling;
                if (menu && menu.classList.contains('dropdown-menu')) {
                    menu.classList.toggle('show');
                }
            });
        });

        // إغلاق القوائم عند النقر خارجها
        document.addEventListener('click', function (e) {
            if (!e.target.closest('.dropdown')) {
                document.querySelectorAll('.dropdown-menu.show').forEach(menu => {
                    menu.classList.remove('show');
                });
            }
        });
    }
});