/**
 * ملف JavaScript لتحسين تفاعلية شجرة الحسابات
 */
$(document).ready(function () {
    // توسيع وطي الشجرة
    $('.coa-toggle').on('click', function () {
        var $parent = $(this).parent();
        var $ul = $parent.find('> ul');

        if ($ul.is(':visible')) {
            $ul.slideUp(200);
            $(this).text('+');
        } else {
            $ul.slideDown(200);
            $(this).text('-');
        }
    });

    // توسيع الكل
    $('#expand-all').on('click', function () {
        $('.coa-tree ul').slideDown(300);
        $('.coa-toggle').text('-');
    });

    // طي الكل
    $('#collapse-all').on('click', function () {
        $('.coa-tree ul').slideUp(300);
        $('.coa-toggle').text('+');
    });

    // تصفية حسب النوع
    $('.filter-btn').on('click', function () {
        // إزالة الفئة النشطة من جميع الأزرار
        $('.filter-btn').removeClass('active');
        // إضافة الفئة النشطة للزر المحدد
        $(this).addClass('active');

        var type = $(this).data('type');

        if (type === 'all') {
            $('.coa-account').parent().fadeIn(300);
        } else {
            $('.coa-account').parent().hide();
            $('.coa-account.' + type).parent().fadeIn(300);

            // عرض الآباء للعناصر المطابقة
            $('.coa-account.' + type).parents('li').show();
            $('.coa-account.' + type).parents('ul').show();
        }
    });

    // تطبيق تأثير البحث
    $('#account-search').on('keyup', function () {
        var searchText = $(this).val().toLowerCase();

        if (searchText.length > 0) {
            $('.coa-account').each(function () {
                var accountName = $(this).find('.coa-account-name a').text().toLowerCase();
                var accountCode = $(this).find('.coa-account-code').text().toLowerCase();
                var accountNameEn = $(this).find('.coa-account-name small').text().toLowerCase();

                if (accountName.indexOf(searchText) > -1 ||
                    accountCode.indexOf(searchText) > -1 ||
                    accountNameEn.indexOf(searchText) > -1) {
                    $(this).parent().show();
                    // توسيع الآباء للعناصر المطابقة
                    $(this).parents('li').show();
                    $(this).parents('ul').show();
                    // تغيير أيقونة التوسيع/الطي
                    $(this).parents('li').find('> .coa-toggle').text('-');
                } else {
                    $(this).parent().hide();
                }
            });
        } else {
            // إذا كان حقل البحث فارغًا، أعد عرض جميع العناصر
            $('.coa-account').parent().show();
        }
    });

    // تطبيق تأثيرات الحركة
    $('.coa-account').hover(
        function () {
            $(this).css('z-index', '10');
        },
        function () {
            $(this).css('z-index', '1');
        }
    );
});