<?php

require_once __DIR__ . '/vendor/autoload.php';

use App\Models\ChartOfAccount;
use Illuminate\Support\Facades\DB;

// تهيئة Laravel
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

echo "بدء نقل حساب البنوك ليكون تحت الأصول المتداولة...\n";

// البحث عن حساب البنوك الرئيسي
$bankAccount = ChartOfAccount::where('account_code', 'BANK')->first();

if (!$bankAccount) {
    echo "لم يتم العثور على حساب البنوك الرئيسي!\n";
    exit;
}

echo "تم العثور على حساب البنوك الرئيسي (ID: {$bankAccount->id}).\n";

// البحث عن حساب الأصول المتداولة
$currentAssetsAccount = ChartOfAccount::where('account_code', '1100')
    ->where('company_id', $bankAccount->company_id)
    ->first();

if (!$currentAssetsAccount) {
    echo "لم يتم العثور على حساب الأصول المتداولة!\n";
    exit;
}

echo "تم العثور على حساب الأصول المتداولة (ID: {$currentAssetsAccount->id}).\n";

// تحديث حساب البنوك ليكون تحت الأصول المتداولة
try {
    // تحديث الحساب
    $bankAccount->parent_id = $currentAssetsAccount->id;
    $bankAccount->level = $currentAssetsAccount->level + 1;
    $bankAccount->name = 'البنوك';
    $bankAccount->name_en = 'Banks';
    $bankAccount->description = 'حساب البنوك الرئيسي';
    $bankAccount->save();

    echo "تم تحديث حساب البنوك بنجاح ليكون تحت الأصول المتداولة.\n";

    // تحديث جميع حسابات البنوك الفرعية لتكون تحت حساب البنوك الرئيسي
    $bankAccounts = ChartOfAccount::where('is_bank_account', true)
        ->where('id', '!=', $bankAccount->id)
        ->where('company_id', $bankAccount->company_id)
        ->get();

    $updatedCount = 0;
    foreach ($bankAccounts as $account) {
        $account->parent_id = $bankAccount->id;
        $account->level = $bankAccount->level + 1;
        $account->save();
        $updatedCount++;
    }

    echo "تم تحديث {$updatedCount} حساب بنك فرعي ليكون تحت حساب البنوك الرئيسي.\n";

    echo "تم الانتهاء من العملية بنجاح!\n";
} catch (\Exception $e) {
    echo "حدث خطأ أثناء تحديث حساب البنوك: " . $e->getMessage() . "\n";
}
