<?php
// تحميل تطبيق لارافيل
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

// البحث عن المستخدم user3
$user = \App\Models\User::where('name', 'like', '%user3%')
    ->orWhere('email', 'like', '%user3%')
    ->first();

if (!$user) {
    echo "لم يتم العثور على المستخدم user3\n";
    exit(1);
}

echo "تم العثور على المستخدم: " . $user->name . " (ID: " . $user->id . ")\n";

// قائمة الصلاحيات التي نريد منحها للمستخدم
$permissions = [
    'manage_users',
    'manage_roles',
    'manage_permissions',
    'view_users',
    'create_users',
    'edit_users',
    'delete_users',
    'view_roles',
    'create_roles',
    'edit_roles',
    'delete_roles'
];

// منح الصلاحيات للمستخدم
$permissionsAdded = 0;
foreach ($permissions as $permissionSlug) {
    $permission = \App\Models\Permission::where('slug', $permissionSlug)->first();
    if ($permission && !$user->permissions->contains($permission->id)) {
        $user->permissions()->attach($permission->id, [
            'granted' => true,
            'source' => 'manual_grant'
        ]);
        echo "تم منح صلاحية: " . $permissionSlug . "\n";
        $permissionsAdded++;
    }
}

// التحقق من دور المستخدم
$managerRole = \App\Models\Role::where('slug', 'company_manager')->first();
if ($managerRole && !$user->roles->contains($managerRole->id)) {
    $user->roles()->attach($managerRole->id);
    echo "تم تعيين المستخدم كمدير للشركة (company_manager)\n";
}

// تنظيف ذاكرة التخزين المؤقت للمستخدم
\Illuminate\Support\Facades\Cache::forget('user_permissions_' . $user->id);

echo "تم منح " . $permissionsAdded . " صلاحيات للمستخدم " . $user->name . "\n";
echo "تم الانتهاء بنجاح!\n";
