<?php

require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

use App\Models\User;
use App\Models\Role;
use App\Models\Permission;
use Illuminate\Support\Facades\DB;

// إيجاد المستخدم التجريبي
$user = User::where('email', 'demo@elevators.com')->first();

if (!$user) {
    echo "المستخدم التجريبي غير موجود!\n";
    exit;
}

// البحث عن دور السوبر أدمن
$superAdminRole = Role::where('name', 'super_admin')
    ->orWhere('slug', 'super_admin')
    ->first();

// إذا لم يكن موجوداً، قم بإنشائه
if (!$superAdminRole) {
    $superAdminRole = new Role();
    $superAdminRole->name = 'super_admin';
    $superAdminRole->display_name = 'مدير النظام';
    $superAdminRole->description = 'لديه جميع الصلاحيات في النظام';
    $superAdminRole->slug = 'super_admin';
    $superAdminRole->save();
    echo "تم إنشاء دور السوبر أدمن\n";
} else {
    echo "تم العثور على دور السوبر أدمن: " . $superAdminRole->name . "\n";
}

// الحصول على جميع الصلاحيات
$allPermissions = Permission::all();

// إعطاء جميع الصلاحيات لدور السوبر أدمن
$superAdminRole->permissions()->sync($allPermissions->pluck('id')->toArray());

// إعطاء دور السوبر أدمن للمستخدم التجريبي
$user->roles()->sync([$superAdminRole->id]);

// تفعيل المستخدم
$user->is_active = true;
$user->save();

echo "تم إعطاء المستخدم {$user->name} ({$user->email}) جميع الصلاحيات بنجاح!\n";
echo "عدد الصلاحيات: " . $allPermissions->count() . "\n";
