<?php

require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\User;
use App\Models\Permission;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

// Find user3 (manager3@manager3.com)
$user = User::where('email', 'manager3@manager3.com')->first();

if (!$user) {
    Log::error('User3 (manager3@manager3.com) not found');
    echo "Error: User3 (manager3@manager3.com) not found\n";
    exit(1);
}

echo "Found user: ID: {$user->id}, Name: {$user->name}, Email: {$user->email}\n";

// Get all banking permissions
$bankingPermissions = Permission::where(function ($query) {
    $query->where('group', 'banks')
        ->orWhere('group', 'bank_accounts')
        ->orWhere('group', 'bank_transactions')
        ->orWhere('group', 'cheques')
        ->orWhere('group', 'bank_reconciliations');
})->get();

if ($bankingPermissions->isEmpty()) {
    Log::error('No banking permissions found. Make sure BankingPermissionsSeeder has been run.');
    echo "Error: No banking permissions found. Make sure BankingPermissionsSeeder has been run.\n";
    exit(1);
}

echo "Found " . $bankingPermissions->count() . " banking permissions\n";

// Get current user permissions
$currentPermissions = $user->permissions()->pluck('permissions.id')->toArray();
echo "User currently has " . count($currentPermissions) . " permissions\n";

// Add banking permissions to user
$newPermissions = array_merge(
    $currentPermissions,
    $bankingPermissions->pluck('id')->toArray()
);

// Update user permissions
$user->permissions()->sync($newPermissions);

echo "Successfully assigned all banking permissions to user3 (manager3@manager3.com)\n";
echo "Total permissions assigned: " . count($newPermissions) . "\n";
