<?php

// تحميل التطبيق
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

// استخدام النماذج
use App\Models\User;
use App\Models\Role;
use Illuminate\Support\Facades\DB;

// الحصول على جميع المستخدمين
$users = User::all();

echo "=== قائمة المستخدمين ===\n";
foreach ($users as $user) {
    echo "ID: " . $user->id . "\n";
    echo "الاسم: " . $user->name . "\n";
    echo "البريد الإلكتروني: " . $user->email . "\n";

    // الحصول على أدوار المستخدم
    echo "الأدوار: ";
    $roles = $user->roles;
    if ($roles->count() > 0) {
        foreach ($roles as $role) {
            echo $role->name . " (" . $role->id . "), ";
        }
    } else {
        echo "لا توجد أدوار";
    }
    echo "\n\n";
}

// الحصول على جميع الأدوار
$roles = Role::all();

echo "=== قائمة الأدوار ===\n";
foreach ($roles as $role) {
    echo "ID: " . $role->id . "\n";
    echo "الاسم: " . $role->name . "\n";
    echo "Slug: " . $role->slug . "\n";
    echo "الوصف: " . $role->description . "\n\n";
}

// الحصول على المستخدمين الذين لديهم دور super_admin أو admin
echo "=== المستخدمين الذين لديهم دور super_admin أو admin ===\n";
$adminUsers = User::whereHas('roles', function ($query) {
    $query->whereIn('slug', ['super_admin', 'admin']);
})->get();

foreach ($adminUsers as $user) {
    echo "ID: " . $user->id . "\n";
    echo "الاسم: " . $user->name . "\n";
    echo "البريد الإلكتروني: " . $user->email . "\n\n";
}
