<?php

require __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

use App\Models\JournalEntry;
use App\Models\JournalEntryItem;
use App\Models\ChartOfAccount;
use Illuminate\Support\Facades\DB;

echo "تصحيح قيود اليومية غير المتوازنة...\n";

// الحصول على حساب فروق ميزان المراجعة (يجب إنشاؤه مسبقًا)
$adjustmentAccount = ChartOfAccount::where('account_code', 'like', '%9999%')
    ->orWhere('name', 'like', '%فروق ميزان المراجعة%')
    ->first();

if (!$adjustmentAccount) {
    echo "لم يتم العثور على حساب فروق ميزان المراجعة. يرجى إنشاء الحساب أولاً.\n";
    exit;
}

// الحصول على جميع قيود اليومية
$entries = JournalEntry::with('items')->get();
$fixedCount = 0;

foreach ($entries as $entry) {
    if (!$entry->isBalanced()) {
        $totalDebit = $entry->total_debit;
        $totalCredit = $entry->total_credit;
        $difference = $totalDebit - $totalCredit;

        echo "تصحيح القيد رقم: " . $entry->entry_number . "\n";
        echo "الفرق: " . $difference . "\n";

        // إنشاء بند تصحيح
        $item = new JournalEntryItem();
        $item->journal_entry_id = $entry->id;
        $item->account_id = $adjustmentAccount->id;
        $item->description = 'تصحيح فرق ميزان المراجعة';

        if ($difference > 0) {
            // إذا كان المدين أكبر، نضيف بند دائن
            $item->debit = 0;
            $item->credit = $difference;
        } else {
            // إذا كان الدائن أكبر، نضيف بند مدين
            $item->debit = abs($difference);
            $item->credit = 0;
        }

        $item->save();
        $fixedCount++;

        echo "تم إضافة بند تصحيح بقيمة: " . abs($difference) . "\n";
        echo "-----------------------------------\n";
    }
}

echo "تم تصحيح " . $fixedCount . " قيد غير متوازن.\n";

// تحديث أرصدة الحسابات بعد التصحيح
if ($fixedCount > 0) {
    echo "\nتحديث أرصدة الحسابات...\n";
    $accounts = ChartOfAccount::all();
    foreach ($accounts as $account) {
        $account->updateBalance();
    }
    echo "تم تحديث أرصدة الحسابات.\n";
}

echo "تم الانتهاء من التصحيح.\n";
