<?php
require 'vendor/autoload.php';
require 'bootstrap/app.php';

// تهيئة التطبيق
$app = $GLOBALS['app'];
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

// بدء معاملة قاعدة البيانات
DB::beginTransaction();

try {
    // البحث عن حساب الخزينة الرئيسية وحساب فروق ميزان المراجعة
    $treasuryAccount = DB::table('chart_of_accounts')
        ->where('account_code', '111001')
        ->first();

    $adjustmentAccount = DB::table('chart_of_accounts')
        ->where('account_code', 'ADJ-DIFF')
        ->first();

    if (!$treasuryAccount || !$adjustmentAccount) {
        throw new Exception('لم يتم العثور على أحد الحسابات المطلوبة');
    }

    // البحث عن السنة المالية والفترة المحاسبية النشطة
    $fiscalYear = DB::table('fiscal_years')
        ->where('is_active', true)
        ->where('is_closed', false)
        ->first();

    if (!$fiscalYear) {
        throw new Exception('لا توجد سنة مالية نشطة');
    }

    $accountingPeriod = DB::table('accounting_periods')
        ->where('fiscal_year_id', $fiscalYear->id)
        ->where('is_closed', false)
        ->where('start_date', '<=', date('Y-m-d'))
        ->where('end_date', '>=', date('Y-m-d'))
        ->first();

    if (!$accountingPeriod) {
        throw new Exception('لا توجد فترة محاسبية نشطة للتاريخ الحالي');
    }

    // إنشاء قيد محاسبي جديد
    $entryNumber = 'ADJ-' . date('Ymd-His');
    $journalEntryId = DB::table('journal_entries')->insertGetId([
        'entry_number' => $entryNumber,
        'entry_date' => date('Y-m-d'),
        'description' => 'تصحيح فرق 10 وحدات في ميزان المراجعة',
        'is_posted' => true,
        'is_approved' => false,
        'fiscal_year_id' => $fiscalYear->id,
        'accounting_period_id' => $accountingPeriod->id,
        'created_at' => now(),
        'updated_at' => now(),
        'posted_at' => now()
    ]);

    // إضافة بنود القيد
    // بند 1: خصم 10 وحدات من حساب الخزينة الرئيسية (زيادة الرصيد السالب)
    DB::table('journal_entry_items')->insert([
        'journal_entry_id' => $journalEntryId,
        'account_id' => $treasuryAccount->id,
        'description' => 'تصحيح فرق ميزان المراجعة - خصم من الخزينة الرئيسية',
        'debit' => 0,
        'credit' => 10,
        'created_at' => now(),
        'updated_at' => now()
    ]);

    // بند 2: إضافة 10 وحدات إلى حساب فروق ميزان المراجعة
    DB::table('journal_entry_items')->insert([
        'journal_entry_id' => $journalEntryId,
        'account_id' => $adjustmentAccount->id,
        'description' => 'تصحيح فرق ميزان المراجعة - إضافة إلى حساب الفروق',
        'debit' => 10,
        'credit' => 0,
        'created_at' => now(),
        'updated_at' => now()
    ]);

    // تحديث أرصدة الحسابات
    // حساب الخزينة الرئيسية: زيادة الرصيد السالب بمقدار 10 وحدات
    DB::table('chart_of_accounts')
        ->where('id', $treasuryAccount->id)
        ->update([
            'current_balance' => $treasuryAccount->current_balance - 10,
            'updated_at' => now()
        ]);

    // حساب فروق ميزان المراجعة: زيادة الرصيد بمقدار 10 وحدات (حساب مصروفات)
    DB::table('chart_of_accounts')
        ->where('id', $adjustmentAccount->id)
        ->update([
            'current_balance' => $adjustmentAccount->current_balance + 10,
            'updated_at' => now()
        ]);

    // تأكيد المعاملة
    DB::commit();

    echo "تم إنشاء قيد التصحيح بنجاح: {$entryNumber}\n";
    echo "تم تصحيح رصيد حساب الخزينة الرئيسية من {$treasuryAccount->current_balance} إلى " . ($treasuryAccount->current_balance - 10) . "\n";
    echo "تم تصحيح رصيد حساب فروق ميزان المراجعة من {$adjustmentAccount->current_balance} إلى " . ($adjustmentAccount->current_balance + 10) . "\n";
} catch (Exception $e) {
    // التراجع عن المعاملة في حالة حدوث خطأ
    DB::rollBack();
    echo "حدث خطأ: " . $e->getMessage() . "\n";
}
