<?php
require_once __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

// البحث عن المستخدم manager3
$user = \App\Models\User::where('email', 'manager3@manager3.com')->first();

if (!$user) {
    echo "لم يتم العثور على المستخدم manager3!\n";
    exit;
}

echo "معلومات المستخدم: " . $user->name . " (ID: " . $user->id . ", البريد الإلكتروني: " . $user->email . ")\n\n";

// الحصول على صلاحيات تفاعلات العملاء ومكافآت العملاء
$interactionPermissions = \App\Models\Permission::where('group', 'customer_interaction')->get();
$rewardPermissions = \App\Models\Permission::where('group', 'customer_reward')->get();

echo "صلاحيات تفاعلات العملاء الموجودة:\n";
foreach ($interactionPermissions as $perm) {
    echo "- " . $perm->name . " (slug: " . $perm->slug . ", ID: " . $perm->id . ")\n";
}

echo "\nصلاحيات مكافآت العملاء الموجودة:\n";
foreach ($rewardPermissions as $perm) {
    echo "- " . $perm->name . " (slug: " . $perm->slug . ", ID: " . $perm->id . ")\n";
}

// إضافة الصلاحيات للمستخدم بشكل مباشر
echo "\nإضافة صلاحيات تفاعلات العملاء للمستخدم...\n";
foreach ($interactionPermissions as $perm) {
    // التحقق مما إذا كان المستخدم يملك الصلاحية بالفعل
    $exists = $user->permissions()->where('permission_id', $perm->id)->exists();

    if (!$exists) {
        // إضافة الصلاحية
        $user->permissions()->attach($perm->id, [
            'granted' => true,
            'source' => 'direct_assignment'
        ]);
        echo "- تمت إضافة صلاحية: " . $perm->name . " (ID: " . $perm->id . ")\n";
    } else {
        echo "- المستخدم يملك بالفعل صلاحية: " . $perm->name . " (ID: " . $perm->id . ")\n";
    }
}

echo "\nإضافة صلاحيات مكافآت العملاء للمستخدم...\n";
foreach ($rewardPermissions as $perm) {
    // التحقق مما إذا كان المستخدم يملك الصلاحية بالفعل
    $exists = $user->permissions()->where('permission_id', $perm->id)->exists();

    if (!$exists) {
        // إضافة الصلاحية
        $user->permissions()->attach($perm->id, [
            'granted' => true,
            'source' => 'direct_assignment'
        ]);
        echo "- تمت إضافة صلاحية: " . $perm->name . " (ID: " . $perm->id . ")\n";
    } else {
        echo "- المستخدم يملك بالفعل صلاحية: " . $perm->name . " (ID: " . $perm->id . ")\n";
    }
}

// إعادة تحميل الصلاحيات
$user->load('permissions');

// إصلاح مشكلة الصلاحيات في الكاش
echo "\nإعادة تعيين كاش الصلاحيات...\n";
// إعادة تعيين كاش الصلاحيات للمستخدم
\Illuminate\Support\Facades\Cache::forget('spatie.permission.cache');
\Illuminate\Support\Facades\Artisan::call('cache:clear');

// إعادة تحميل المستخدم بعد مسح الكاش
$user = \App\Models\User::where('email', 'manager3@manager3.com')->first();

// التحقق من الصلاحيات بعد الإضافة
echo "\nالتحقق من صلاحيات تفاعلات العملاء بعد الإضافة:\n";
foreach ($interactionPermissions as $perm) {
    // استخدام الطريقة المباشرة للتحقق من الصلاحيات
    $hasPermission = $user->permissions()->where('permission_id', $perm->id)->exists();
    echo "- " . $perm->slug . ": " . ($hasPermission ? "نعم" : "لا") . "\n";
}

echo "\nالتحقق من صلاحيات مكافآت العملاء بعد الإضافة:\n";
foreach ($rewardPermissions as $perm) {
    // استخدام الطريقة المباشرة للتحقق من الصلاحيات
    $hasPermission = $user->permissions()->where('permission_id', $perm->id)->exists();
    echo "- " . $perm->slug . ": " . ($hasPermission ? "نعم" : "لا") . "\n";
}

echo "\nتم الانتهاء من إضافة الصلاحيات للمستخدم manager3.\n";
