<?php

require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

// تعديل طريقة التحقق من الصلاحيات في ملف User.php
$userModelPath = __DIR__ . '/app/Models/User.php';
$userModelContent = file_get_contents($userModelPath);

// البحث عن الدالة hasPermission واستبدالها
$oldFunction = <<<'EOD'
    /**
     * التحقق مما إذا كان المستخدم لديه الصلاحية المحددة.
     *
     * @param string|Permission $permission
     * @return bool
     */
    public function hasPermission($permission)
    {

        if ($this->is_admin) {
            return true;
        }

        // التحقق من الصلاحيات المباشرة أولاً
        $permissionId = is_string($permission)
            ? Permission::where('slug', $permission)->value('id')
            : $permission->id;

        if ($permissionId) {
            // التحقق من وجود صلاحية مباشرة محظورة (تجاوز)
            $directPermission = $this->directPermissions()
                ->where('permission_id', $permissionId)
                ->where(function ($query) {
                    $query->whereNull('expires_at')
                        ->orWhere('expires_at', '>', now());
                })
                ->first();

            if ($directPermission) {
                return $directPermission->granted;
            }
        }

        // التحقق من الصلاحيات عبر الأدوار
        foreach ($this->roles as $role) {
            if ($role->hasPermission($permission)) {
                return true;
            }
        }

        return false;
    }
EOD;

$newFunction = <<<'EOD'
    /**
     * التحقق مما إذا كان المستخدم لديه الصلاحية المحددة.
     *
     * @param string|Permission $permission
     * @return bool
     */
    public function hasPermission($permission)
    {
        if ($this->is_admin) {
            return true;
        }

        // التحقق من الصلاحيات المباشرة أولاً
        $permissionId = null;
        
        if (is_string($permission)) {
            // البحث عن الصلاحية بواسطة الاسم أو المعرف
            $permObj = Permission::where('name', $permission)
                ->orWhere('slug', $permission)
                ->orWhere('slug', str_replace('_', '-', $permission))
                ->first();
                
            if ($permObj) {
                $permissionId = $permObj->id;
            }
        } else {
            $permissionId = $permission->id;
        }

        if ($permissionId) {
            // التحقق من وجود صلاحية مباشرة محظورة (تجاوز)
            $directPermission = $this->directPermissions()
                ->where('permission_id', $permissionId)
                ->where(function ($query) {
                    $query->whereNull('expires_at')
                        ->orWhere('expires_at', '>', now());
                })
                ->first();

            if ($directPermission) {
                return $directPermission->granted;
            }
        }

        // التحقق من الصلاحيات عبر الأدوار
        foreach ($this->roles as $role) {
            if ($role->hasPermission($permission)) {
                return true;
            }
        }

        return false;
    }
EOD;

$updatedContent = str_replace($oldFunction, $newFunction, $userModelContent);

// تعديل طريقة التحقق من الصلاحيات في ملف Role.php
$roleModelPath = __DIR__ . '/app/Models/Role.php';
$roleModelContent = file_get_contents($roleModelPath);

$oldRoleFunction = <<<'EOD'
    /**
     * التحقق مما إذا كان الدور لديه الصلاحية المحددة.
     *
     * @param string|Permission $permission
     * @return bool
     */
    public function hasPermission($permission)
    {
        if (is_string($permission)) {
            return $this->permissions->contains('slug', $permission);
        }

        if ($permission instanceof Permission) {
            return $this->permissions->contains('id', $permission->id);
        }

        return !!$permission->intersect($this->permissions)->count();
    }
EOD;

$newRoleFunction = <<<'EOD'
    /**
     * التحقق مما إذا كان الدور لديه الصلاحية المحددة.
     *
     * @param string|Permission $permission
     * @return bool
     */
    public function hasPermission($permission)
    {
        if (is_string($permission)) {
            // البحث عن الصلاحية بواسطة الاسم أو المعرف
            return $this->permissions->contains('name', $permission) || 
                   $this->permissions->contains('slug', $permission) ||
                   $this->permissions->contains('slug', str_replace('_', '-', $permission));
        }

        if ($permission instanceof Permission) {
            return $this->permissions->contains('id', $permission->id);
        }

        return !!$permission->intersect($this->permissions)->count();
    }
EOD;

$updatedRoleContent = str_replace($oldRoleFunction, $newRoleFunction, $roleModelContent);

// حفظ التغييرات
if (file_put_contents($userModelPath, $updatedContent)) {
    echo "تم تحديث ملف User.php بنجاح\n";
} else {
    echo "فشل في تحديث ملف User.php\n";
}

if (file_put_contents($roleModelPath, $updatedRoleContent)) {
    echo "تم تحديث ملف Role.php بنجاح\n";
} else {
    echo "فشل في تحديث ملف Role.php\n";
}

echo "تم الانتهاء من تصحيح طريقة التحقق من الصلاحيات\n";
