<?php
require_once __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

try {
    // البحث عن دور الفني
    $techRole = \App\Models\Role::where('name', 'فني')->first();
    if (!$techRole) {
        echo "لم يتم العثور على دور الفني\n";
        exit(1);
    }

    echo "تم العثور على دور الفني: " . $techRole->name . " (ID: " . $techRole->id . ")\n";

    // إنشاء صلاحية view_maintenance_notifications إذا لم تكن موجودة
    $permSlug = 'view_maintenance_notifications';
    $permission = \App\Models\Permission::where('slug', $permSlug)->first();

    if (!$permission) {
        echo "الصلاحية " . $permSlug . " غير موجودة، سيتم إنشاؤها الآن...\n";

        $permission = new \App\Models\Permission();
        $permission->name = 'عرض إشعارات الصيانة';
        $permission->slug = $permSlug;
        $permission->description = 'عرض إشعارات الصيانة';
        $permission->group = 'maintenance_notifications';
        $permission->type = 'view';
        $permission->is_active = true;
        $permission->save();

        // تحديث المسار والمستوى إذا كانت هذه الدوال موجودة
        if (method_exists($permission, 'updatePath')) {
            $permission->updatePath();
        }

        if (method_exists($permission, 'updateLevel')) {
            $permission->updateLevel();
        }

        echo "تم إنشاء الصلاحية " . $permission->name . " (" . $permSlug . ") بنجاح\n";
    } else {
        echo "الصلاحية " . $permission->name . " (" . $permSlug . ") موجودة بالفعل\n";
    }

    // إضافة الصلاحية لدور الفني
    $exists = \DB::table('permission_role')
        ->where('permission_id', $permission->id)
        ->where('role_id', $techRole->id)
        ->exists();

    if (!$exists) {
        \DB::table('permission_role')->insert([
            'permission_id' => $permission->id,
            'role_id' => $techRole->id,
            'created_at' => now(),
            'updated_at' => now()
        ]);
        echo "تم إضافة الصلاحية " . $permission->name . " (" . $permSlug . ") لدور الفني\n";
    } else {
        echo "الصلاحية " . $permission->name . " (" . $permSlug . ") مضافة بالفعل لدور الفني\n";
    }

    // التحقق من المستخدم
    $user = \App\Models\User::where('email', 'fany@fany.com')->first();
    if (!$user) {
        echo "لم يتم العثور على المستخدم fany@fany.com\n";
        exit(1);
    }

    echo "تم العثور على المستخدم: " . $user->name . " (ID: " . $user->id . ")\n";

    // مسح ذاكرة التخزين المؤقت للصلاحيات
    \Illuminate\Support\Facades\Cache::flush();
    echo "تم مسح ذاكرة التخزين المؤقت للصلاحيات\n";

    echo "تم تنفيذ العملية بنجاح\n";
} catch (\Exception $e) {
    echo "حدث خطأ: " . $e->getMessage() . "\n";
    echo "في الملف: " . $e->getFile() . " على السطر: " . $e->getLine() . "\n";
}
