<?php

// تحميل التطبيق
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

// إصلاح القيد المحاسبي رقم 33
try {
    $entry = \App\Models\JournalEntry::find(33);

    if ($entry) {
        echo "تم العثور على القيد المحاسبي رقم 33\n";
        echo "حالة الترحيل: " . ($entry->is_posted ? "مرحل" : "غير مرحل") . "\n";

        if ($entry->is_posted) {
            // حذف أي سجلات موجودة لهذا القيد
            \App\Models\CustomerStatement::where('reference_type', 'App\\Models\\JournalEntry')
                ->where('reference_id', $entry->id)
                ->delete();

            echo "تم حذف أي سجلات سابقة في كشف حساب العميل لهذا القيد\n";

            // إنشاء كشف حساب جديد
            $statement = \App\Models\CustomerStatement::createForJournalEntry($entry);

            if ($statement) {
                echo "تم إنشاء كشف حساب للعميل بنجاح\n";
                echo "معرف كشف الحساب: " . $statement->id . "\n";
                echo "العميل: " . $statement->customer_id . "\n";
                echo "المبلغ المدين: " . $statement->debit . "\n";
                echo "المبلغ الدائن: " . $statement->credit . "\n";
                echo "الرصيد: " . $statement->balance . "\n";
            } else {
                echo "لم يتم إنشاء كشف حساب للعميل. قد لا يكون هناك حساب عميل في هذا القيد.\n";
            }
        } else {
            echo "القيد غير مرحل. يجب ترحيل القيد أولاً.\n";
        }
    } else {
        echo "لم يتم العثور على القيد المحاسبي رقم 33\n";
    }
} catch (\Exception $e) {
    echo "حدث خطأ: " . $e->getMessage() . "\n";
    echo "في الملف: " . $e->getFile() . " على السطر: " . $e->getLine() . "\n";
}
